/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.concurrent;

import java.util.concurrent.locks.Lock;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.Assertions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lease.Releasable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.engine.EngineException;

public class ReleasableLock
implements Releasable {
    private final Lock lock;
    private final ThreadLocal<Integer> holdingThreads;

    public ReleasableLock(Lock lock) {
        this.lock = lock;
        this.holdingThreads = Assertions.ENABLED ? new ThreadLocal() : null;
    }

    @Override
    public void close() {
        this.lock.unlock();
        assert (this.removeCurrentThread());
    }

    public ReleasableLock acquire() throws EngineException {
        this.lock.lock();
        assert (this.addCurrentThread());
        return this;
    }

    private boolean addCurrentThread() {
        Integer current = this.holdingThreads.get();
        this.holdingThreads.set(current == null ? 1 : current + 1);
        return true;
    }

    private boolean removeCurrentThread() {
        Integer count = this.holdingThreads.get();
        assert (count != null && count > 0);
        if (count == 1) {
            this.holdingThreads.remove();
        } else {
            this.holdingThreads.set(count - 1);
        }
        return true;
    }

    public boolean isHeldByCurrentThread() {
        if (this.holdingThreads == null) {
            throw new UnsupportedOperationException("asserts must be enabled");
        }
        Integer count = this.holdingThreads.get();
        return count != null && count > 0;
    }
}

