/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.concurrent;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public class RunOnce
implements Runnable {
    private final Runnable delegate;
    private final AtomicBoolean hasRun;

    public RunOnce(Runnable delegate) {
        this.delegate = Objects.requireNonNull(delegate);
        this.hasRun = new AtomicBoolean(false);
    }

    @Override
    public void run() {
        if (this.hasRun.compareAndSet(false, true)) {
            this.delegate.run();
        }
    }

    public boolean hasRun() {
        return this.hasRun.get();
    }
}

