/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.gateway;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.cursors.ObjectCursor;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.ClusterChangedEvent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.ClusterStateListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.IndexGraveyard;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.Metadata;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.Setting;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.env.NodeEnvironment;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.gateway.LocalAllocateDangledIndices;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.gateway.MetaStateService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.Index;

public class DanglingIndicesState
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(DanglingIndicesState.class);
    public static final Setting<Boolean> AUTO_IMPORT_DANGLING_INDICES_SETTING = Setting.boolSetting("gateway.auto_import_dangling_indices", true, Setting.Property.NodeScope, Setting.Property.Deprecated);
    private final NodeEnvironment nodeEnv;
    private final MetaStateService metaStateService;
    private final LocalAllocateDangledIndices allocateDangledIndices;
    private final boolean isAutoImportDanglingIndicesEnabled;
    private final Map<Index, IndexMetadata> danglingIndices = ConcurrentCollections.newConcurrentMap();

    @Inject
    public DanglingIndicesState(NodeEnvironment nodeEnv, MetaStateService metaStateService, LocalAllocateDangledIndices allocateDangledIndices, ClusterService clusterService) {
        this.nodeEnv = nodeEnv;
        this.metaStateService = metaStateService;
        this.allocateDangledIndices = allocateDangledIndices;
        this.isAutoImportDanglingIndicesEnabled = AUTO_IMPORT_DANGLING_INDICES_SETTING.get(clusterService.getSettings());
        if (this.isAutoImportDanglingIndicesEnabled) {
            clusterService.addListener(this);
        } else {
            logger.warn(AUTO_IMPORT_DANGLING_INDICES_SETTING.getKey() + " is disabled, dangling indices will not be detected or imported");
        }
    }

    boolean isAutoImportDanglingIndicesEnabled() {
        return this.isAutoImportDanglingIndicesEnabled;
    }

    public void processDanglingIndices(Metadata metadata) {
        if (!this.nodeEnv.hasNodeFile()) {
            return;
        }
        this.cleanupAllocatedDangledIndices(metadata);
        this.findNewAndAddDanglingIndices(metadata);
        this.allocateDanglingIndices();
    }

    Map<Index, IndexMetadata> getDanglingIndices() {
        return Collections.unmodifiableMap(new HashMap<Index, IndexMetadata>(this.danglingIndices));
    }

    void cleanupAllocatedDangledIndices(Metadata metadata) {
        for (Index index : this.danglingIndices.keySet()) {
            IndexMetadata indexMetadata = metadata.index(index);
            if (indexMetadata == null || !indexMetadata.getIndex().getName().equals(index.getName())) continue;
            if (!indexMetadata.getIndex().getUUID().equals(index.getUUID())) {
                logger.warn("[{}] can not be imported as a dangling index, as there is already another index with the same name but a different uuid. local index will be ignored (but not deleted)", (Object)index);
            } else {
                logger.debug("[{}] no longer dangling (created), removing from dangling list", (Object)index);
            }
            this.danglingIndices.remove(index);
        }
    }

    void findNewAndAddDanglingIndices(Metadata metadata) {
        this.danglingIndices.putAll(this.findNewDanglingIndices(metadata));
    }

    Map<Index, IndexMetadata> findNewDanglingIndices(Metadata metadata) {
        HashSet<String> excludeIndexPathIds = new HashSet<String>(metadata.indices().size() + this.danglingIndices.size());
        for (ObjectCursor<IndexMetadata> objectCursor : metadata.indices().values()) {
            excludeIndexPathIds.add(((IndexMetadata)objectCursor.value).getIndex().getUUID());
        }
        excludeIndexPathIds.addAll(this.danglingIndices.keySet().stream().map(Index::getUUID).collect(Collectors.toList()));
        try {
            List<IndexMetadata> indexMetadataList = this.metaStateService.loadIndicesStates(excludeIndexPathIds::contains);
            HashMap<Index, IndexMetadata> hashMap = new HashMap<Index, IndexMetadata>(indexMetadataList.size());
            IndexGraveyard graveyard = metadata.indexGraveyard();
            for (IndexMetadata indexMetadata : indexMetadataList) {
                if (metadata.hasIndex(indexMetadata.getIndex().getName())) {
                    logger.warn("[{}] can not be imported as a dangling index, as index with same name already exists in cluster metadata", (Object)indexMetadata.getIndex());
                    continue;
                }
                if (graveyard.containsIndex(indexMetadata.getIndex())) {
                    logger.warn("[{}] can not be imported as a dangling index, as an index with the same name and UUID exist in the index tombstones.  This situation is likely caused by copying over the data directory for an index that was previously deleted.", (Object)indexMetadata.getIndex());
                    continue;
                }
                logger.info("[{}] dangling index exists on local file system, but not in cluster metadata, auto import to cluster state", (Object)indexMetadata.getIndex());
                hashMap.put(indexMetadata.getIndex(), this.stripAliases(indexMetadata));
            }
            return hashMap;
        }
        catch (IOException e) {
            logger.warn("failed to list dangling indices", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private IndexMetadata stripAliases(IndexMetadata indexMetadata) {
        if (indexMetadata.getAliases().isEmpty()) {
            return indexMetadata;
        }
        logger.info("[{}] stripping aliases: {} from index before importing", (Object)indexMetadata.getIndex(), indexMetadata.getAliases().keys());
        return IndexMetadata.builder(indexMetadata).removeAllAliases().build();
    }

    void allocateDanglingIndices() {
        if (this.danglingIndices.isEmpty()) {
            return;
        }
        try {
            this.allocateDangledIndices.allocateDangled(Collections.unmodifiableCollection(new ArrayList<IndexMetadata>(this.danglingIndices.values())), new ActionListener<LocalAllocateDangledIndices.AllocateDangledResponse>(){

                @Override
                public void onResponse(LocalAllocateDangledIndices.AllocateDangledResponse response) {
                    logger.trace("allocated dangled");
                }

                @Override
                public void onFailure(Exception e) {
                    logger.info("failed to send allocated dangled", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            logger.warn("failed to send allocate dangled", (Throwable)e);
        }
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (!event.state().blocks().disableStatePersistence()) {
            this.processDanglingIndices(event.state().metadata());
        }
    }
}

