/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.codec;

import org.apache.logging.log4j.Logger;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.codecs.Codec;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.codecs.PostingsFormat;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.codecs.lucene50.Lucene50StoredFieldsFormat;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.codecs.lucene84.Lucene84Codec;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.CompletionFieldMapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MapperService;

public class PerFieldMappingPostingFormatCodec
extends Lucene84Codec {
    private final Logger logger;
    private final MapperService mapperService;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PerFieldMappingPostingFormatCodec(Lucene50StoredFieldsFormat.Mode compressionMode, MapperService mapperService, Logger logger) {
        super(compressionMode);
        this.mapperService = mapperService;
        this.logger = logger;
    }

    @Override
    public PostingsFormat getPostingsFormatForField(String field) {
        MappedFieldType fieldType = this.mapperService.fieldType(field);
        if (fieldType == null) {
            this.logger.warn("no index mapper found for field: [{}] returning default postings format", (Object)field);
        } else if (fieldType instanceof CompletionFieldMapper.CompletionFieldType) {
            return CompletionFieldMapper.CompletionFieldType.postingsFormat();
        }
        return super.getPostingsFormatForField(field);
    }

    static {
        boolean bl = $assertionsDisabled = !PerFieldMappingPostingFormatCodec.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !Codec.forName("Lucene84").getClass().isAssignableFrom(PerFieldMappingPostingFormatCodec.class)) {
            throw new AssertionError((Object)"PerFieldMappingPostingFormatCodec must subclass the latest lucene codec: Lucene84");
        }
    }
}

