/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.DirectoryReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.FieldComparatorSource;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Scorer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.SortField;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Weight;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.join.BitSetProducer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BitSet;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.BigArrays;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.IndexComponent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.LeafFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MapperService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.DocValueFormat;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.MultiValueMode;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.sort.BucketedSort;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.sort.NestedSortBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.sort.SortOrder;

public interface IndexFieldData<FD extends LeafFieldData>
extends IndexComponent {
    public String getFieldName();

    public FD load(LeafReaderContext var1);

    public FD loadDirect(LeafReaderContext var1) throws Exception;

    public SortField sortField(@Nullable Object var1, MultiValueMode var2, XFieldComparatorSource.Nested var3, boolean var4);

    public BucketedSort newBucketedSort(BigArrays var1, @Nullable Object var2, MultiValueMode var3, XFieldComparatorSource.Nested var4, SortOrder var5, DocValueFormat var6, int var7, BucketedSort.ExtraData var8);

    public void clear();

    public static interface Global<FD extends LeafFieldData>
    extends IndexFieldData<FD> {
        public IndexFieldData<FD> loadGlobal(DirectoryReader var1);

        public IndexFieldData<FD> localGlobalDirect(DirectoryReader var1) throws Exception;
    }

    public static interface Builder {
        public IndexFieldData<?> build(IndexSettings var1, MappedFieldType var2, IndexFieldDataCache var3, CircuitBreakerService var4, MapperService var5);
    }

    public static abstract class XFieldComparatorSource
    extends FieldComparatorSource {
        protected final MultiValueMode sortMode;
        protected final Object missingValue;
        protected final Nested nested;

        public XFieldComparatorSource(Object missingValue, MultiValueMode sortMode, Nested nested) {
            this.sortMode = sortMode;
            this.missingValue = missingValue;
            this.nested = nested;
        }

        public MultiValueMode sortMode() {
            return this.sortMode;
        }

        public Nested nested() {
            return this.nested;
        }

        public final boolean sortMissingFirst(Object missingValue) {
            return "_first".equals(missingValue);
        }

        public final boolean sortMissingLast(Object missingValue) {
            return missingValue == null || "_last".equals(missingValue);
        }

        public final Object missingObject(Object missingValue, boolean reversed) {
            if (this.sortMissingFirst(missingValue) || this.sortMissingLast(missingValue)) {
                boolean min = this.sortMissingFirst(missingValue) ^ reversed;
                switch (this.reducedType()) {
                    case INT: {
                        return min ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                    }
                    case LONG: {
                        return min ? Long.MIN_VALUE : Long.MAX_VALUE;
                    }
                    case FLOAT: {
                        return Float.valueOf(min ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY);
                    }
                    case DOUBLE: {
                        return min ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                    }
                    case STRING: 
                    case STRING_VAL: {
                        return null;
                    }
                }
                throw new UnsupportedOperationException("Unsupported reduced type: " + (Object)((Object)this.reducedType()));
            }
            switch (this.reducedType()) {
                case INT: {
                    if (missingValue instanceof Number) {
                        return ((Number)missingValue).intValue();
                    }
                    return Integer.parseInt(missingValue.toString());
                }
                case LONG: {
                    if (missingValue instanceof Number) {
                        return ((Number)missingValue).longValue();
                    }
                    return Long.parseLong(missingValue.toString());
                }
                case FLOAT: {
                    if (missingValue instanceof Number) {
                        return Float.valueOf(((Number)missingValue).floatValue());
                    }
                    return Float.valueOf(Float.parseFloat(missingValue.toString()));
                }
                case DOUBLE: {
                    if (missingValue instanceof Number) {
                        return ((Number)missingValue).doubleValue();
                    }
                    return Double.parseDouble(missingValue.toString());
                }
                case STRING: 
                case STRING_VAL: {
                    if (missingValue instanceof BytesRef) {
                        return (BytesRef)missingValue;
                    }
                    if (missingValue instanceof byte[]) {
                        return new BytesRef((byte[])missingValue);
                    }
                    return new BytesRef(missingValue.toString());
                }
            }
            throw new UnsupportedOperationException("Unsupported reduced type: " + (Object)((Object)this.reducedType()));
        }

        public abstract SortField.Type reducedType();

        public Object missingValue(boolean reversed) {
            return null;
        }

        public abstract BucketedSort newBucketedSort(BigArrays var1, SortOrder var2, DocValueFormat var3, int var4, BucketedSort.ExtraData var5);

        public static class Nested {
            private final BitSetProducer rootFilter;
            private final Query innerQuery;
            private final NestedSortBuilder nestedSort;
            private final IndexSearcher searcher;

            public Nested(BitSetProducer rootFilter, Query innerQuery, NestedSortBuilder nestedSort, IndexSearcher searcher) {
                this.rootFilter = rootFilter;
                this.innerQuery = innerQuery;
                this.nestedSort = nestedSort;
                this.searcher = searcher;
            }

            public Query getInnerQuery() {
                return this.innerQuery;
            }

            public NestedSortBuilder getNestedSort() {
                return this.nestedSort;
            }

            public BitSet rootDocs(LeafReaderContext ctx) throws IOException {
                return this.rootFilter.getBitSet(ctx);
            }

            public DocIdSetIterator innerDocs(LeafReaderContext ctx) throws IOException {
                Weight weight = this.searcher.createWeight(this.searcher.rewrite(this.innerQuery), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
                Scorer s = weight.scorer(ctx);
                return s == null ? null : s.iterator();
            }
        }
    }
}

