/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.ObjectLongHashMap;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Accountable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.FieldMemoryStats;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.metrics.CounterMetric;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.regex.Regex;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.FieldDataStats;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.shard.ShardId;

public class ShardFieldData
implements IndexFieldDataCache.Listener {
    private final CounterMetric evictionsMetric = new CounterMetric();
    private final CounterMetric totalMetric = new CounterMetric();
    private final ConcurrentMap<String, CounterMetric> perFieldTotals = ConcurrentCollections.newConcurrentMap();

    public FieldDataStats stats(String ... fields) {
        ObjectLongHashMap<String> fieldTotals = null;
        if (fields != null && fields.length > 0) {
            fieldTotals = new ObjectLongHashMap<String>();
            for (Map.Entry entry : this.perFieldTotals.entrySet()) {
                if (!Regex.simpleMatch(fields, (String)entry.getKey())) continue;
                fieldTotals.put((String)entry.getKey(), ((CounterMetric)entry.getValue()).count());
            }
        }
        return new FieldDataStats(this.totalMetric.count(), this.evictionsMetric.count(), fieldTotals == null ? null : new FieldMemoryStats(fieldTotals));
    }

    @Override
    public void onCache(ShardId shardId, String fieldName, Accountable ramUsage) {
        this.totalMetric.inc(ramUsage.ramBytesUsed());
        CounterMetric total = (CounterMetric)this.perFieldTotals.get(fieldName);
        if (total != null) {
            total.inc(ramUsage.ramBytesUsed());
        } else {
            total = new CounterMetric();
            total.inc(ramUsage.ramBytesUsed());
            CounterMetric prev = this.perFieldTotals.putIfAbsent(fieldName, total);
            if (prev != null) {
                prev.inc(ramUsage.ramBytesUsed());
            }
        }
    }

    @Override
    public void onRemoval(ShardId shardId, String fieldName, boolean wasEvicted, long sizeInBytes) {
        if (wasEvicted) {
            this.evictionsMetric.inc();
        }
        if (sizeInBytes != -1L) {
            this.totalMetric.dec(sizeInBytes);
            CounterMetric total = (CounterMetric)this.perFieldTotals.get(fieldName);
            if (total != null) {
                total.dec(sizeInBytes);
            }
        }
    }
}

