/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.DirectoryReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.DocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.SortedSetDocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.SortField;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Accountable;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.BigArrays;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.AbstractSortedDocValues;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.LeafOrdinalsFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.plain.AbstractIndexOrdinalsFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.plain.AbstractLeafOrdinalsFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MapperService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.DocValueFormat;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.MultiValueMode;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.sort.BucketedSort;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.sort.SortOrder;

public class ConstantIndexFieldData
extends AbstractIndexOrdinalsFieldData {
    private final ConstantLeafFieldData atomicFieldData;

    private ConstantIndexFieldData(IndexSettings indexSettings, String name, String value) {
        super(indexSettings, name, null, null, 0.0, 2.147483647E9, 0);
        this.atomicFieldData = new ConstantLeafFieldData(value);
    }

    @Override
    public void clear() {
    }

    @Override
    public final LeafOrdinalsFieldData load(LeafReaderContext context) {
        return this.atomicFieldData;
    }

    @Override
    public LeafOrdinalsFieldData loadDirect(LeafReaderContext context) throws Exception {
        return this.atomicFieldData;
    }

    @Override
    public SortField sortField(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        BytesRefFieldComparatorSource source = new BytesRefFieldComparatorSource(this, missingValue, sortMode, nested);
        return new SortField(this.getFieldName(), source, reverse);
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        throw new IllegalArgumentException("only supported on numeric fields");
    }

    @Override
    public IndexOrdinalsFieldData loadGlobal(DirectoryReader indexReader) {
        return this;
    }

    @Override
    public IndexOrdinalsFieldData localGlobalDirect(DirectoryReader indexReader) throws Exception {
        return this.loadGlobal(indexReader);
    }

    public String getValue() {
        return this.atomicFieldData.value;
    }

    private static class ConstantLeafFieldData
    extends AbstractLeafOrdinalsFieldData {
        private final String value;

        ConstantLeafFieldData(String value) {
            super(DEFAULT_SCRIPT_FUNCTION);
            this.value = value;
        }

        @Override
        public long ramBytesUsed() {
            return 0L;
        }

        @Override
        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }

        @Override
        public SortedSetDocValues getOrdinalsValues() {
            if (this.value == null) {
                return DocValues.emptySortedSet();
            }
            final BytesRef term = new BytesRef(this.value);
            AbstractSortedDocValues sortedValues = new AbstractSortedDocValues(){
                private int docID = -1;

                @Override
                public BytesRef lookupOrd(int ord) {
                    return term;
                }

                @Override
                public int getValueCount() {
                    return 1;
                }

                @Override
                public int ordValue() {
                    return 0;
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    this.docID = target;
                    return true;
                }

                @Override
                public int docID() {
                    return this.docID;
                }
            };
            return DocValues.singleton(sortedValues);
        }

        @Override
        public void close() {
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final Function<MapperService, String> valueFunction;

        public Builder(Function<MapperService, String> valueFunction) {
            this.valueFunction = valueFunction;
        }

        @Override
        public IndexFieldData<?> build(IndexSettings indexSettings, MappedFieldType fieldType, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
            return new ConstantIndexFieldData(indexSettings, fieldType.name(), this.valueFunction.apply(mapperService));
        }
    }
}

