/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.collect.CopyOnWriteHashMap;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.collect.Iterators;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.regex.Regex;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.DynamicKeyFieldMapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.DynamicKeyFieldTypeLookup;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.FieldAliasMapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.FieldMapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MappedFieldType;

class FieldTypeLookup
implements Iterable<MappedFieldType> {
    final CopyOnWriteHashMap<String, MappedFieldType> fullNameToFieldType;
    private final CopyOnWriteHashMap<String, String> aliasToConcreteName;
    private final DynamicKeyFieldTypeLookup dynamicKeyLookup;

    FieldTypeLookup() {
        this.fullNameToFieldType = new CopyOnWriteHashMap();
        this.aliasToConcreteName = new CopyOnWriteHashMap();
        this.dynamicKeyLookup = new DynamicKeyFieldTypeLookup();
    }

    private FieldTypeLookup(CopyOnWriteHashMap<String, MappedFieldType> fullNameToFieldType, CopyOnWriteHashMap<String, String> aliasToConcreteName, DynamicKeyFieldTypeLookup dynamicKeyLookup) {
        this.fullNameToFieldType = fullNameToFieldType;
        this.aliasToConcreteName = aliasToConcreteName;
        this.dynamicKeyLookup = dynamicKeyLookup;
    }

    public FieldTypeLookup copyAndAddAll(String type, Collection<FieldMapper> fieldMappers, Collection<FieldAliasMapper> fieldAliasMappers) {
        Objects.requireNonNull(type, "type must not be null");
        if ("_default_".equals(type)) {
            throw new IllegalArgumentException("Default mappings should not be added to the lookup");
        }
        CopyOnWriteHashMap<String, MappedFieldType> fullName = this.fullNameToFieldType;
        CopyOnWriteHashMap<String, String> aliases = this.aliasToConcreteName;
        HashMap<String, DynamicKeyFieldMapper> dynamicKeyMappers = new HashMap<String, DynamicKeyFieldMapper>();
        for (FieldMapper fieldMapper : fieldMappers) {
            MappedFieldType fullNameFieldType;
            String fieldName = fieldMapper.name();
            MappedFieldType fieldType = fieldMapper.fieldType();
            if (!Objects.equals(fieldType, fullNameFieldType = fullName.get(fieldType.name()))) {
                fullName = fullName.copyAndPut(fieldType.name(), fieldType);
            }
            if (!(fieldMapper instanceof DynamicKeyFieldMapper)) continue;
            dynamicKeyMappers.put(fieldName, (DynamicKeyFieldMapper)fieldMapper);
        }
        for (FieldAliasMapper fieldAliasMapper : fieldAliasMappers) {
            String aliasName = fieldAliasMapper.name();
            String path = fieldAliasMapper.path();
            aliases = aliases.copyAndPut(aliasName, path);
        }
        DynamicKeyFieldTypeLookup newDynamicKeyLookup = this.dynamicKeyLookup.copyAndAddAll(dynamicKeyMappers, aliases);
        return new FieldTypeLookup(fullName, aliases, newDynamicKeyLookup);
    }

    public MappedFieldType get(String field) {
        String concreteField = this.aliasToConcreteName.getOrDefault(field, field);
        MappedFieldType fieldType = this.fullNameToFieldType.get(concreteField);
        if (fieldType != null) {
            return fieldType;
        }
        return this.dynamicKeyLookup.get(field);
    }

    public Set<String> simpleMatchToFullName(String pattern) {
        HashSet<String> fields = new HashSet<String>();
        for (MappedFieldType fieldType : this) {
            if (!Regex.simpleMatch(pattern, fieldType.name())) continue;
            fields.add(fieldType.name());
        }
        for (String aliasName : this.aliasToConcreteName.keySet()) {
            if (!Regex.simpleMatch(pattern, aliasName)) continue;
            fields.add(aliasName);
        }
        return fields;
    }

    @Override
    public Iterator<MappedFieldType> iterator() {
        Iterator concreteFieldTypes = this.fullNameToFieldType.values().iterator();
        Iterator<MappedFieldType> keyedFieldTypes = this.dynamicKeyLookup.fieldTypes();
        return Iterators.concat(concreteFieldTypes, keyedFieldTypes);
    }
}

