/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.LatLonDocValuesField;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.LatLonPoint;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.StoredField;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexableField;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ElasticsearchParseException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Explicit;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.geo.GeoPoint;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.geo.GeoUtils;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.plain.AbstractLatLonPointDVIndexFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.FieldMapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.Mapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MapperParsingException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.ParseContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.TypeParsers;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryShardContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.VectorGeoPointShapeQueryProcessor;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class GeoPointFieldMapper
extends AbstractGeometryFieldMapper {
    public static final String CONTENT_TYPE = "geo_point";

    public GeoPointFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, FieldMapper.MultiFields multiFields, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, ignoreMalformed, ignoreZValue, multiFields, copyTo);
    }

    @Override
    public final boolean parsesArrayValue() {
        return true;
    }

    @Override
    protected void doMerge(Mapper mergeWith) {
        super.doMerge(mergeWith);
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected void parse(ParseContext context, GeoPoint point) throws IOException {
        if (!((Boolean)this.ignoreMalformed.value()).booleanValue()) {
            if (point.lat() > 90.0 || point.lat() < -90.0) {
                throw new IllegalArgumentException("illegal latitude value [" + point.lat() + "] for " + this.name());
            }
            if (point.lon() > 180.0 || point.lon() < -180.0) {
                throw new IllegalArgumentException("illegal longitude value [" + point.lon() + "] for " + this.name());
            }
        } else if (this.isNormalizable(point.lat()) && this.isNormalizable(point.lon())) {
            GeoUtils.normalizePoint(point);
        } else {
            throw new ElasticsearchParseException("cannot normalize the point - not a number", new Object[0]);
        }
        if (this.fieldType().indexOptions() != IndexOptions.NONE) {
            context.doc().add(new LatLonPoint(this.fieldType().name(), point.lat(), point.lon()));
        }
        if (this.fieldType().stored()) {
            context.doc().add(new StoredField(this.fieldType().name(), point.toString()));
        }
        if (this.fieldType.hasDocValues()) {
            context.doc().add(new LatLonDocValuesField(this.fieldType().name(), point.lat(), point.lon()));
        } else if (this.fieldType().stored() || this.fieldType().indexOptions() != IndexOptions.NONE) {
            ArrayList<IndexableField> fields = new ArrayList<IndexableField>(1);
            this.createFieldNamesField(context, fields);
            for (IndexableField field : fields) {
                context.doc().add(field);
            }
        }
        if (this.multiFields.iterator().hasNext()) {
            this.multiFields.parse(this, context.createExternalValueContext(point.geohash()));
        }
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        context.path().add(this.simpleName());
        try {
            GeoPoint sparse = context.parseExternalValue(GeoPoint.class);
            if (sparse != null) {
                this.parse(context, sparse);
            } else {
                sparse = new GeoPoint();
                XContentParser.Token token = context.parser().currentToken();
                if (token == XContentParser.Token.START_ARRAY) {
                    token = context.parser().nextToken();
                    if (token == XContentParser.Token.VALUE_NUMBER) {
                        double lon = context.parser().doubleValue();
                        context.parser().nextToken();
                        double lat = context.parser().doubleValue();
                        token = context.parser().nextToken();
                        if (token == XContentParser.Token.VALUE_NUMBER) {
                            GeoPoint.assertZValue((Boolean)this.ignoreZValue.value(), context.parser().doubleValue());
                        } else if (token != XContentParser.Token.END_ARRAY) {
                            throw new ElasticsearchParseException("[{}] field type does not accept > 3 dimensions", CONTENT_TYPE);
                        }
                        this.parse(context, sparse.reset(lat, lon));
                    } else {
                        while (token != XContentParser.Token.END_ARRAY) {
                            this.parseGeoPointIgnoringMalformed(context, sparse);
                            token = context.parser().nextToken();
                        }
                    }
                } else if (token == XContentParser.Token.VALUE_NULL) {
                    if (this.fieldType.nullValue() != null) {
                        this.parse(context, (GeoPoint)this.fieldType.nullValue());
                    }
                } else {
                    this.parseGeoPointIgnoringMalformed(context, sparse);
                }
            }
        }
        catch (Exception ex) {
            throw new MapperParsingException("failed to parse field [{}] of type [{}]", (Throwable)ex, this.fieldType().name(), this.fieldType().typeName());
        }
        context.path().remove();
    }

    private void parseGeoPointIgnoringMalformed(ParseContext context, GeoPoint sparse) throws IOException {
        try {
            this.parse(context, GeoUtils.parseGeoPoint(context.parser(), sparse, (Boolean)this.ignoreZValue.value()));
        }
        catch (ElasticsearchParseException e) {
            if (!((Boolean)this.ignoreMalformed.value()).booleanValue()) {
                throw e;
            }
            context.addIgnoredField(this.fieldType.name());
        }
    }

    @Override
    public void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.fieldType().nullValue() != null) {
            builder.field(Names.NULL_VALUE.getPreferredName(), this.fieldType().nullValue());
        }
    }

    private boolean isNormalizable(double coord) {
        return !Double.isNaN(coord) && !Double.isInfinite(coord);
    }

    public static class Names
    extends AbstractGeometryFieldMapper.Names {
        public static final ParseField NULL_VALUE = new ParseField("null_value", new String[0]);
    }

    public static class GeoPointFieldType
    extends AbstractGeometryFieldMapper.AbstractGeometryFieldType {
        public GeoPointFieldType() {
            this.setHasDocValues(true);
            this.setDimensions(2, 4);
        }

        GeoPointFieldType(GeoPointFieldType ref) {
            super(ref);
        }

        @Override
        public String typeName() {
            return GeoPointFieldMapper.CONTENT_TYPE;
        }

        @Override
        public MappedFieldType clone() {
            return new GeoPointFieldType(this);
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            this.failIfNoDocValues();
            return new AbstractLatLonPointDVIndexFieldData.Builder();
        }

        @Override
        public ValuesSourceType getValuesSourceType() {
            return CoreValuesSourceType.GEOPOINT;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            if (this.hasDocValues()) {
                return new DocValuesFieldExistsQuery(this.name());
            }
            return super.existsQuery(context);
        }
    }

    public static class TypeParser
    extends AbstractGeometryFieldMapper.TypeParser<Builder> {
        @Override
        protected Builder newBuilder(String name, Map<String, Object> params) {
            return new Builder(name);
        }

        @Override
        public Builder parse(String name, Map<String, Object> node, Map<String, Object> params, Mapper.TypeParser.ParserContext parserContext) {
            Builder builder = (Builder)super.parse(name, node, params, parserContext);
            TypeParsers.parseField(builder, name, node, parserContext);
            Object nullValue = null;
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (!Names.NULL_VALUE.match(propName, LoggingDeprecationHandler.INSTANCE)) continue;
                if (propNode == null) {
                    throw new MapperParsingException("Property [null_value] cannot be null.");
                }
                nullValue = propNode;
                iterator.remove();
            }
            if (nullValue != null) {
                boolean ignoreZValue = builder.ignoreZValue().value();
                boolean ignoreMalformed = builder.ignoreMalformed().value();
                GeoPoint point = GeoUtils.parseGeoPoint(nullValue, ignoreZValue);
                if (!ignoreMalformed) {
                    if (point.lat() > 90.0 || point.lat() < -90.0) {
                        throw new IllegalArgumentException("illegal latitude value [" + point.lat() + "]");
                    }
                    if (point.lon() > 180.0 || point.lon() < -180.0) {
                        throw new IllegalArgumentException("illegal longitude value [" + point.lon() + "]");
                    }
                } else {
                    GeoUtils.normalizePoint(point);
                }
                builder.nullValue(point);
            }
            return builder;
        }
    }

    public static class Builder
    extends AbstractGeometryFieldMapper.Builder<Builder, GeoPointFieldMapper> {
        public Builder(String name) {
            super(name, new GeoPointFieldType(), new GeoPointFieldType());
            this.builder = this;
        }

        public GeoPointFieldMapper build(Mapper.BuilderContext context, String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, FieldMapper.MultiFields multiFields, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, FieldMapper.CopyTo copyTo) {
            this.setupFieldType(context);
            return new GeoPointFieldMapper(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, ignoreMalformed, ignoreZValue, copyTo);
        }

        @Override
        protected void setupFieldType(Mapper.BuilderContext context) {
            super.setupFieldType(context);
            GeoPointFieldType fieldType = this.fieldType();
            fieldType.setGeometryQueryBuilder(new VectorGeoPointShapeQueryProcessor());
        }

        @Override
        public GeoPointFieldMapper build(Mapper.BuilderContext context) {
            return this.build(context, this.name, this.fieldType, this.defaultFieldType, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.ignoreMalformed(context), this.ignoreZValue(context), this.copyTo);
        }

        @Override
        public GeoPointFieldType fieldType() {
            return (GeoPointFieldType)this.fieldType;
        }
    }
}

