/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.FeatureField;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexableField;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lucene.Lucene;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.FieldMapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.Mapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MapperParsingException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.ParseContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryShardContext;

public class RankFeaturesFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "rank_features";

    private RankFeaturesFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        assert (fieldType.indexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) <= 0);
    }

    @Override
    protected RankFeaturesFieldMapper clone() {
        return (RankFeaturesFieldMapper)super.clone();
    }

    @Override
    public RankFeaturesFieldType fieldType() {
        return (RankFeaturesFieldType)super.fieldType();
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        if (context.externalValueSet()) {
            throw new IllegalArgumentException("[rank_features] fields can't be used in multi-fields");
        }
        if (context.parser().currentToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("[rank_features] fields must be json objects, expected a START_OBJECT but got: " + (Object)((Object)context.parser().currentToken()));
        }
        String feature = null;
        XContentParser.Token token = context.parser().nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                feature = context.parser().currentName();
            } else if (token != XContentParser.Token.VALUE_NULL) {
                if (token == XContentParser.Token.VALUE_NUMBER || token == XContentParser.Token.VALUE_STRING) {
                    String key = this.name() + "." + feature;
                    float value = context.parser().floatValue(true);
                    if (context.doc().getByKey(key) != null) {
                        throw new IllegalArgumentException("[rank_features] fields do not support indexing multiple values for the same rank feature [" + key + "] in the same document");
                    }
                    context.doc().addWithKey(key, new FeatureField(this.name(), feature, value));
                } else {
                    throw new IllegalArgumentException("[rank_features] fields take hashes that map a feature to a strictly positive float, but got unexpected token " + (Object)((Object)token));
                }
            }
            token = context.parser().nextToken();
        }
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        throw new AssertionError((Object)"parse is implemented directly");
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static final class RankFeaturesFieldType
    extends MappedFieldType {
        public RankFeaturesFieldType() {
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            this.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
        }

        protected RankFeaturesFieldType(RankFeaturesFieldType ref) {
            super(ref);
        }

        @Override
        public RankFeaturesFieldType clone() {
            return new RankFeaturesFieldType(this);
        }

        @Override
        public String typeName() {
            return RankFeaturesFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            throw new IllegalArgumentException("[rank_features] fields do not support [exists] queries");
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            throw new IllegalArgumentException("[rank_features] fields do not support sorting, scripting or aggregating");
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new IllegalArgumentException("Queries on [rank_features] fields are not supported");
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, RankFeaturesFieldMapper> {
        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        @Override
        public RankFeaturesFieldType fieldType() {
            return (RankFeaturesFieldType)super.fieldType();
        }

        @Override
        public RankFeaturesFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new RankFeaturesFieldMapper(this.name, this.fieldType, this.defaultFieldType, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final MappedFieldType FIELD_TYPE = new RankFeaturesFieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.setHasDocValues(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

