/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.seqno;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionRequestValidationException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.ActionFilters;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.routing.ShardsIterator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lease.Releasable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.IndexService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.shard.IndexShard;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.shard.ShardId;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.indices.IndicesService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.threadpool.ThreadPool;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportService;

public class RetentionLeaseActions {
    public static final long RETAIN_ALL = -1L;

    public static class Response
    extends ActionResponse {
        public Response() {
        }

        Response(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
        }
    }

    public static class RemoveRequest
    extends Request<RemoveRequest> {
        RemoveRequest(StreamInput in) throws IOException {
            super(in);
        }

        public RemoveRequest(ShardId shardId, String id) {
            super(shardId, id);
        }
    }

    public static class RenewRequest
    extends AddOrRenewRequest<RenewRequest> {
        RenewRequest(StreamInput in) throws IOException {
            super(in);
        }

        public RenewRequest(ShardId shardId, String id, long retainingSequenceNumber, String source) {
            super(shardId, id, retainingSequenceNumber, source);
        }
    }

    public static class AddRequest
    extends AddOrRenewRequest<AddRequest> {
        AddRequest(StreamInput in) throws IOException {
            super(in);
        }

        public AddRequest(ShardId shardId, String id, long retainingSequenceNumber, String source) {
            super(shardId, id, retainingSequenceNumber, source);
        }
    }

    private static abstract class AddOrRenewRequest<T extends SingleShardRequest<T>>
    extends Request<T> {
        private final long retainingSequenceNumber;
        private final String source;

        public long getRetainingSequenceNumber() {
            return this.retainingSequenceNumber;
        }

        public String getSource() {
            return this.source;
        }

        AddOrRenewRequest(StreamInput in) throws IOException {
            super(in);
            this.retainingSequenceNumber = in.readZLong();
            this.source = in.readString();
        }

        AddOrRenewRequest(ShardId shardId, String id, long retainingSequenceNumber, String source) {
            super(shardId, id);
            if (retainingSequenceNumber < 0L && retainingSequenceNumber != -1L) {
                throw new IllegalArgumentException("retaining sequence number [" + retainingSequenceNumber + "] out of range");
            }
            this.retainingSequenceNumber = retainingSequenceNumber;
            this.source = Objects.requireNonNull(source);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeZLong(this.retainingSequenceNumber);
            out.writeString(this.source);
        }
    }

    private static abstract class Request<T extends SingleShardRequest<T>>
    extends SingleShardRequest<T> {
        private final ShardId shardId;
        private final String id;

        public ShardId getShardId() {
            return this.shardId;
        }

        public String getId() {
            return this.id;
        }

        Request(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
            this.id = in.readString();
        }

        Request(ShardId shardId, String id) {
            super(Objects.requireNonNull(shardId).getIndexName());
            this.shardId = shardId;
            this.id = Objects.requireNonNull(id);
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            out.writeString(this.id);
        }
    }

    public static class Remove
    extends ActionType<Response> {
        public static final Remove INSTANCE = new Remove();
        public static final String ACTION_NAME = "indices:admin/seq_no/remove_retention_lease";

        private Remove() {
            super(ACTION_NAME, Response::new);
        }

        public static class TransportAction
        extends TransportRetentionLeaseAction<RemoveRequest> {
            @Inject
            public TransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
                super(Remove.ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, indicesService, RemoveRequest::new);
            }

            @Override
            void doRetentionLeaseAction(IndexShard indexShard, RemoveRequest request, ActionListener<Response> listener) {
                indexShard.removeRetentionLease(request.getId(), ActionListener.map(listener, r -> new Response()));
            }
        }
    }

    public static class Renew
    extends ActionType<Response> {
        public static final Renew INSTANCE = new Renew();
        public static final String ACTION_NAME = "indices:admin/seq_no/renew_retention_lease";

        private Renew() {
            super(ACTION_NAME, Response::new);
        }

        public static class TransportAction
        extends TransportRetentionLeaseAction<RenewRequest> {
            @Inject
            public TransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
                super(Renew.ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, indicesService, RenewRequest::new);
            }

            @Override
            void doRetentionLeaseAction(IndexShard indexShard, RenewRequest request, ActionListener<Response> listener) {
                indexShard.renewRetentionLease(request.getId(), request.getRetainingSequenceNumber(), request.getSource());
                listener.onResponse(new Response());
            }
        }
    }

    public static class Add
    extends ActionType<Response> {
        public static final Add INSTANCE = new Add();
        public static final String ACTION_NAME = "indices:admin/seq_no/add_retention_lease";

        private Add() {
            super(ACTION_NAME, Response::new);
        }

        public static class TransportAction
        extends TransportRetentionLeaseAction<AddRequest> {
            @Inject
            public TransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
                super(Add.ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, indicesService, AddRequest::new);
            }

            @Override
            void doRetentionLeaseAction(IndexShard indexShard, AddRequest request, ActionListener<Response> listener) {
                indexShard.addRetentionLease(request.getId(), request.getRetainingSequenceNumber(), request.getSource(), ActionListener.map(listener, r -> new Response()));
            }

            @Override
            protected Writeable.Reader<Response> getResponseReader() {
                return Response::new;
            }
        }
    }

    static abstract class TransportRetentionLeaseAction<T extends Request<T>>
    extends TransportSingleShardAction<T, Response> {
        private final IndicesService indicesService;

        @Inject
        TransportRetentionLeaseAction(String name, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService, Writeable.Reader<T> requestSupplier) {
            super(name, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, requestSupplier, "management");
            this.indicesService = Objects.requireNonNull(indicesService);
        }

        @Override
        protected ShardsIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
            return state.routingTable().shardRoutingTable(request.concreteIndex(), ((Request)request.request()).getShardId().id()).primaryShardIt();
        }

        @Override
        protected void asyncShardOperation(T request, ShardId shardId, ActionListener<Response> listener) {
            IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
            IndexShard indexShard = indexService.getShard(shardId.id());
            indexShard.acquirePrimaryOperationPermit(ActionListener.delegateFailure(listener, (delegatedListener, releasable) -> {
                try (Releasable ignore = releasable;){
                    this.doRetentionLeaseAction(indexShard, request, (ActionListener<Response>)delegatedListener);
                }
            }), "same", request);
        }

        @Override
        protected Response shardOperation(T request, ShardId shardId) {
            throw new UnsupportedOperationException();
        }

        abstract void doRetentionLeaseAction(IndexShard var1, T var2, ActionListener<Response> var3);

        @Override
        protected Writeable.Reader<Response> getResponseReader() {
            return Response::new;
        }

        @Override
        protected boolean resolveIndex(T request) {
            return false;
        }
    }
}

