/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.shard;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.Assertions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ExceptionsHelper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionRunnable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.ContextPreservingActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.CheckedRunnable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.collect.Tuple;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lease.Releasable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.concurrent.RunOnce;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.concurrent.ThreadContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.core.internal.io.IOUtils;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.shard.IndexShardClosedException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.shard.ShardId;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.threadpool.ThreadPool;

final class IndexShardOperationPermits
implements Closeable {
    private final ShardId shardId;
    private final ThreadPool threadPool;
    static final int TOTAL_PERMITS = Integer.MAX_VALUE;
    final Semaphore semaphore = new Semaphore(Integer.MAX_VALUE, true);
    private final List<DelayedOperation> delayedOperations = new ArrayList<DelayedOperation>();
    private volatile boolean closed;
    private int queuedBlockOperations;
    private final Map<AtomicBoolean, Tuple<String, StackTraceElement[]>> issuedPermits;

    IndexShardOperationPermits(ShardId shardId, ThreadPool threadPool) {
        this.shardId = shardId;
        this.threadPool = threadPool;
        this.issuedPermits = Assertions.ENABLED ? new ConcurrentHashMap<AtomicBoolean, Tuple<String, StackTraceElement[]>>() : null;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <E extends Exception> void blockOperations(long timeout, TimeUnit timeUnit, CheckedRunnable<E> onBlocked) throws InterruptedException, TimeoutException, E {
        this.delayOperations();
        try (Releasable ignored = this.acquireAll(timeout, timeUnit);){
            onBlocked.run();
        }
        finally {
            this.releaseDelayedOperations();
        }
    }

    public void asyncBlockOperations(final ActionListener<Releasable> onAcquired, final long timeout, final TimeUnit timeUnit) {
        this.delayOperations();
        this.threadPool.executor("generic").execute(new AbstractRunnable(){
            final RunOnce released = new RunOnce(() -> IndexShardOperationPermits.access$100(IndexShardOperationPermits.this));

            @Override
            public void onFailure(Exception e) {
                try {
                    this.released.run();
                }
                finally {
                    onAcquired.onFailure(e);
                }
            }

            @Override
            protected void doRun() throws Exception {
                Releasable releasable = IndexShardOperationPermits.this.acquireAll(timeout, timeUnit);
                onAcquired.onResponse(() -> {
                    try {
                        releasable.close();
                    }
                    finally {
                        this.released.run();
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delayOperations() {
        if (this.closed) {
            throw new IndexShardClosedException(this.shardId);
        }
        IndexShardOperationPermits indexShardOperationPermits = this;
        synchronized (indexShardOperationPermits) {
            assert (this.queuedBlockOperations > 0 || this.delayedOperations.isEmpty());
            ++this.queuedBlockOperations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Releasable acquireAll(long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        if (Assertions.ENABLED) {
            IndexShardOperationPermits indexShardOperationPermits = this;
            synchronized (indexShardOperationPermits) {
                assert (this.queuedBlockOperations > 0);
            }
        }
        if (this.semaphore.tryAcquire(Integer.MAX_VALUE, timeout, timeUnit)) {
            RunOnce release = new RunOnce(() -> {
                assert (this.semaphore.availablePermits() == 0);
                this.semaphore.release(Integer.MAX_VALUE);
            });
            return release::run;
        }
        throw new TimeoutException("timeout while blocking operations");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseDelayedOperations() {
        List queuedActions;
        IndexShardOperationPermits indexShardOperationPermits = this;
        synchronized (indexShardOperationPermits) {
            assert (this.queuedBlockOperations > 0);
            --this.queuedBlockOperations;
            if (this.queuedBlockOperations == 0) {
                queuedActions = new ArrayList<DelayedOperation>(this.delayedOperations);
                this.delayedOperations.clear();
            } else {
                queuedActions = Collections.emptyList();
            }
        }
        if (!queuedActions.isEmpty()) {
            this.threadPool.executor("generic").execute(() -> {
                for (DelayedOperation queuedAction : queuedActions) {
                    this.acquire(queuedAction.listener, null, false, queuedAction.debugInfo, queuedAction.stackTrace);
                }
            });
        }
    }

    public void acquire(ActionListener<Releasable> onAcquired, String executorOnDelay, boolean forceExecution, Object debugInfo) {
        StackTraceElement[] stackTrace = Assertions.ENABLED ? Thread.currentThread().getStackTrace() : null;
        this.acquire(onAcquired, executorOnDelay, forceExecution, debugInfo, stackTrace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquire(ActionListener<Releasable> onAcquired, String executorOnDelay, final boolean forceExecution, Object debugInfo, StackTraceElement[] stackTrace) {
        Releasable releasable;
        if (this.closed) {
            onAcquired.onFailure(new IndexShardClosedException(this.shardId));
            return;
        }
        try {
            IndexShardOperationPermits indexShardOperationPermits = this;
            synchronized (indexShardOperationPermits) {
                if (this.queuedBlockOperations > 0) {
                    Supplier<ThreadContext.StoredContext> contextSupplier = this.threadPool.getThreadContext().newRestorableContext(false);
                    ActionListener<Releasable> wrappedListener = executorOnDelay != null ? ActionListener.delegateFailure(new ContextPreservingActionListener<Releasable>(contextSupplier, onAcquired), (l, r) -> this.threadPool.executor(executorOnDelay).execute(new ActionRunnable<Releasable>(l){

                        @Override
                        public boolean isForceExecution() {
                            return forceExecution;
                        }

                        @Override
                        protected void doRun() {
                            this.listener.onResponse(r);
                        }

                        @Override
                        public void onRejection(Exception e) {
                            IOUtils.closeWhileHandlingException(r);
                            super.onRejection(e);
                        }
                    })) : new ContextPreservingActionListener<Releasable>(contextSupplier, onAcquired);
                    this.delayedOperations.add(new DelayedOperation(wrappedListener, debugInfo, stackTrace));
                    return;
                }
                releasable = this.acquire(debugInfo, stackTrace);
            }
        }
        catch (InterruptedException e) {
            onAcquired.onFailure(e);
            return;
        }
        onAcquired.onResponse(releasable);
    }

    private Releasable acquire(Object debugInfo, StackTraceElement[] stackTrace) throws InterruptedException {
        assert (Thread.holdsLock(this));
        if (this.semaphore.tryAcquire(1, 0L, TimeUnit.SECONDS)) {
            AtomicBoolean closed = new AtomicBoolean();
            Releasable releasable = () -> {
                if (closed.compareAndSet(false, true)) {
                    if (Assertions.ENABLED) {
                        Tuple<String, StackTraceElement[]> existing = this.issuedPermits.remove(closed);
                        assert (existing != null);
                    }
                    this.semaphore.release(1);
                }
            };
            if (Assertions.ENABLED) {
                this.issuedPermits.put(closed, new Tuple<String, StackTraceElement[]>(debugInfo.toString(), stackTrace));
            }
            return releasable;
        }
        throw new IllegalStateException("failed to obtain permit but operations are not delayed");
    }

    int getActiveOperationsCount() {
        int availablePermits = this.semaphore.availablePermits();
        if (availablePermits == 0) {
            return -1;
        }
        return Integer.MAX_VALUE - availablePermits;
    }

    synchronized boolean isBlocked() {
        return this.queuedBlockOperations > 0;
    }

    List<String> getActiveOperations() {
        return this.issuedPermits.values().stream().map(t -> (String)t.v1() + "\n" + ExceptionsHelper.formatStackTrace((StackTraceElement[])t.v2())).collect(Collectors.toList());
    }

    private static class DelayedOperation {
        private final ActionListener<Releasable> listener;
        private final String debugInfo;
        private final StackTraceElement[] stackTrace;

        private DelayedOperation(ActionListener<Releasable> listener, Object debugInfo, StackTraceElement[] stackTrace) {
            this.listener = listener;
            if (Assertions.ENABLED) {
                this.debugInfo = "[delayed] " + debugInfo;
                this.stackTrace = stackTrace;
            } else {
                this.debugInfo = null;
                this.stackTrace = null;
            }
        }
    }
}

