/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.shard;

import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.engine.Engine;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.shard.ShardId;

public interface IndexingOperationListener {
    default public Engine.Index preIndex(ShardId shardId, Engine.Index operation) {
        return operation;
    }

    default public void postIndex(ShardId shardId, Engine.Index index, Engine.IndexResult result) {
    }

    default public void postIndex(ShardId shardId, Engine.Index index, Exception ex) {
    }

    default public Engine.Delete preDelete(ShardId shardId, Engine.Delete delete) {
        return delete;
    }

    default public void postDelete(ShardId shardId, Engine.Delete delete, Engine.DeleteResult result) {
    }

    default public void postDelete(ShardId shardId, Engine.Delete delete, Exception ex) {
    }

    public static final class CompositeListener
    implements IndexingOperationListener {
        private final List<IndexingOperationListener> listeners;
        private final Logger logger;

        public CompositeListener(List<IndexingOperationListener> listeners, Logger logger) {
            this.listeners = listeners;
            this.logger = logger;
        }

        @Override
        public Engine.Index preIndex(ShardId shardId, Engine.Index operation) {
            assert (operation != null);
            for (IndexingOperationListener listener : this.listeners) {
                try {
                    listener.preIndex(shardId, operation);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("preIndex listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
            return operation;
        }

        @Override
        public void postIndex(ShardId shardId, Engine.Index index, Engine.IndexResult result) {
            assert (index != null);
            for (IndexingOperationListener listener : this.listeners) {
                try {
                    listener.postIndex(shardId, index, result);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("postIndex listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void postIndex(ShardId shardId, Engine.Index index, Exception ex) {
            assert (index != null && ex != null);
            for (IndexingOperationListener listener : this.listeners) {
                try {
                    listener.postIndex(shardId, index, ex);
                }
                catch (Exception inner) {
                    inner.addSuppressed(ex);
                    this.logger.warn(() -> new ParameterizedMessage("postIndex listener [{}] failed", (Object)listener), (Throwable)inner);
                }
            }
        }

        @Override
        public Engine.Delete preDelete(ShardId shardId, Engine.Delete delete) {
            assert (delete != null);
            for (IndexingOperationListener listener : this.listeners) {
                try {
                    listener.preDelete(shardId, delete);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("preDelete listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
            return delete;
        }

        @Override
        public void postDelete(ShardId shardId, Engine.Delete delete, Engine.DeleteResult result) {
            assert (delete != null);
            for (IndexingOperationListener listener : this.listeners) {
                try {
                    listener.postDelete(shardId, delete, result);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("postDelete listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void postDelete(ShardId shardId, Engine.Delete delete, Exception ex) {
            assert (delete != null && ex != null);
            for (IndexingOperationListener listener : this.listeners) {
                try {
                    listener.postDelete(shardId, delete, ex);
                }
                catch (Exception inner) {
                    inner.addSuppressed(ex);
                    this.logger.warn(() -> new ParameterizedMessage("postDelete listener [{}] failed", (Object)listener), (Throwable)inner);
                }
            }
        }
    }
}

