/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.indices.recovery;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.Assertions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.collect.Tuple;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.concurrent.AsyncIOProcessor;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.concurrent.ThreadContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.core.internal.io.IOUtils;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.seqno.LocalCheckpointTracker;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.store.StoreFileMetadata;

public abstract class MultiFileTransfer<Request extends ChunkRequest>
implements Closeable {
    private Status status = Status.PROCESSING;
    private final Logger logger;
    private final ActionListener<Void> listener;
    private final LocalCheckpointTracker requestSeqIdTracker = new LocalCheckpointTracker(-1L, -1L);
    private final AsyncIOProcessor<FileChunkResponseItem> processor;
    private final int maxConcurrentFileChunks;
    private StoreFileMetadata currentFile = null;
    private final Iterator<StoreFileMetadata> remainingFiles;
    private Tuple<StoreFileMetadata, Request> readAheadRequest = null;

    protected MultiFileTransfer(Logger logger, ThreadContext threadContext, ActionListener<Void> listener, int maxConcurrentFileChunks, List<StoreFileMetadata> files) {
        this.logger = logger;
        this.maxConcurrentFileChunks = maxConcurrentFileChunks;
        this.listener = listener;
        this.processor = new AsyncIOProcessor<FileChunkResponseItem>(logger, maxConcurrentFileChunks, threadContext){

            @Override
            protected void write(List<Tuple<FileChunkResponseItem, Consumer<Exception>>> items) {
                MultiFileTransfer.this.handleItems(items);
            }
        };
        this.remainingFiles = files.iterator();
    }

    public final void start() {
        this.addItem(-2L, null, null);
    }

    private void addItem(long requestSeqId, StoreFileMetadata md, Exception failure) {
        this.processor.put(new FileChunkResponseItem(requestSeqId, md, failure), e -> {
            assert (e == null) : e;
        });
    }

    private void handleItems(List<Tuple<FileChunkResponseItem, Consumer<Exception>>> items) {
        if (this.status != Status.PROCESSING) {
            assert (this.status == Status.FAILED) : "must not receive any response after the transfer was completed";
            items.stream().filter(item -> ((FileChunkResponseItem)item.v1()).failure != null).forEach(item -> this.logger.debug((Message)new ParameterizedMessage("failed to transfer a file chunk request {}", (Object)((FileChunkResponseItem)item.v1()).md), (Throwable)((FileChunkResponseItem)item.v1()).failure));
            return;
        }
        try {
            for (Tuple<FileChunkResponseItem, Consumer<Exception>> item2 : items) {
                FileChunkResponseItem resp = item2.v1();
                if (resp.requestSeqId == -2L) continue;
                this.requestSeqIdTracker.markSeqNoAsProcessed(resp.requestSeqId);
                if (resp.failure == null) continue;
                this.handleError(resp.md, resp.failure);
                throw resp.failure;
            }
            while (this.requestSeqIdTracker.getMaxSeqNo() - this.requestSeqIdTracker.getProcessedCheckpoint() < (long)this.maxConcurrentFileChunks) {
                Tuple<StoreFileMetadata, Request> request = this.readAheadRequest != null ? this.readAheadRequest : this.getNextRequest();
                this.readAheadRequest = null;
                if (request == null) {
                    assert (this.currentFile == null && !this.remainingFiles.hasNext());
                    if (this.requestSeqIdTracker.getMaxSeqNo() == this.requestSeqIdTracker.getProcessedCheckpoint()) {
                        this.onCompleted(null);
                    }
                    return;
                }
                long requestSeqId = this.requestSeqIdTracker.generateSeqNo();
                this.executeChunkRequest((ChunkRequest)request.v2(), ActionListener.wrap(r -> this.addItem(requestSeqId, (StoreFileMetadata)request.v1(), null), e -> this.addItem(requestSeqId, (StoreFileMetadata)request.v1(), (Exception)e)));
            }
            if (this.readAheadRequest == null) {
                this.readAheadRequest = this.getNextRequest();
            }
        }
        catch (Exception e2) {
            this.onCompleted(e2);
        }
    }

    private void onCompleted(Exception failure) {
        if (Assertions.ENABLED && this.status != Status.PROCESSING) {
            throw new AssertionError("invalid status: expected [" + (Object)((Object)Status.PROCESSING) + "] actual [" + (Object)((Object)this.status) + "]", failure);
        }
        this.status = failure == null ? Status.SUCCESS : Status.FAILED;
        try {
            IOUtils.close(failure, this);
        }
        catch (Exception e) {
            this.listener.onFailure(e);
            return;
        }
        this.listener.onResponse(null);
    }

    private Tuple<StoreFileMetadata, Request> getNextRequest() throws Exception {
        try {
            StoreFileMetadata md;
            Request request;
            if (this.currentFile == null) {
                if (this.remainingFiles.hasNext()) {
                    this.currentFile = this.remainingFiles.next();
                    this.onNewFile(this.currentFile);
                } else {
                    return null;
                }
            }
            if ((request = this.nextChunkRequest(md = this.currentFile)).lastChunk()) {
                this.currentFile = null;
            }
            return Tuple.tuple(md, request);
        }
        catch (Exception e) {
            this.handleError(this.currentFile, e);
            throw e;
        }
    }

    protected abstract void onNewFile(StoreFileMetadata var1) throws IOException;

    protected abstract Request nextChunkRequest(StoreFileMetadata var1) throws IOException;

    protected abstract void executeChunkRequest(Request var1, ActionListener<Void> var2);

    protected abstract void handleError(StoreFileMetadata var1, Exception var2) throws Exception;

    private static enum Status {
        PROCESSING,
        SUCCESS,
        FAILED;

    }

    private static class FileChunkResponseItem {
        final long requestSeqId;
        final StoreFileMetadata md;
        final Exception failure;

        FileChunkResponseItem(long requestSeqId, StoreFileMetadata md, Exception failure) {
            this.requestSeqId = requestSeqId;
            this.md = md;
            this.failure = failure;
        }
    }

    public static interface ChunkRequest {
        public boolean lastChunk();
    }
}

