/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.indices.recovery;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ExceptionsHelper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.ChannelActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.PlainActionFuture;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.routing.ShardRouting;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.concurrent.FutureUtils;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.IndexService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.shard.IndexEventListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.shard.IndexShard;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.shard.ShardId;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.indices.IndicesService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.indices.recovery.DelayRecoveryException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.indices.recovery.RecoveryResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.indices.recovery.RecoverySettings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.indices.recovery.RecoverySourceHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.indices.recovery.RemoteRecoveryTargetHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.indices.recovery.StartRecoveryRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.tasks.Task;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportChannel;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportRequestHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportService;

public class PeerRecoverySourceService
extends AbstractLifecycleComponent
implements IndexEventListener {
    private static final Logger logger = LogManager.getLogger(PeerRecoverySourceService.class);
    private final TransportService transportService;
    private final IndicesService indicesService;
    private final RecoverySettings recoverySettings;
    final OngoingRecoveries ongoingRecoveries = new OngoingRecoveries();

    @Inject
    public PeerRecoverySourceService(TransportService transportService, IndicesService indicesService, RecoverySettings recoverySettings) {
        this.transportService = transportService;
        this.indicesService = indicesService;
        this.recoverySettings = recoverySettings;
        transportService.registerRequestHandler("internal:index/shard/recovery/start_recovery", "generic", StartRecoveryRequest::new, new StartRecoveryTransportRequestHandler());
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
        this.ongoingRecoveries.awaitEmpty();
    }

    @Override
    protected void doClose() {
    }

    @Override
    public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
        if (indexShard != null) {
            this.ongoingRecoveries.cancel(indexShard, "shard is closed");
        }
    }

    private void recover(StartRecoveryRequest request, ActionListener<RecoveryResponse> listener) {
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexShard shard = indexService.getShard(request.shardId().id());
        ShardRouting routingEntry = shard.routingEntry();
        if (!routingEntry.primary() || !routingEntry.active()) {
            throw new DelayRecoveryException("source shard [" + routingEntry + "] is not an active primary");
        }
        if (!(!request.isPrimaryRelocation() || routingEntry.relocating() && routingEntry.relocatingNodeId().equals(request.targetNode().getId()))) {
            logger.debug("delaying recovery of {} as source shard is not marked yet as relocating to {}", (Object)request.shardId(), (Object)request.targetNode());
            throw new DelayRecoveryException("source shard is not marked yet as relocating to [" + request.targetNode() + "]");
        }
        RecoverySourceHandler handler = this.ongoingRecoveries.addNewRecovery(request, shard);
        logger.trace("[{}][{}] starting recovery to {}", (Object)request.shardId().getIndex().getName(), (Object)request.shardId().id(), (Object)request.targetNode());
        handler.recoverToTarget(ActionListener.runAfter(listener, () -> this.ongoingRecoveries.remove(shard, handler)));
    }

    final int numberOfOngoingRecoveries() {
        return this.ongoingRecoveries.ongoingRecoveries.size();
    }

    final class OngoingRecoveries {
        private final Map<IndexShard, ShardRecoveryContext> ongoingRecoveries = new HashMap<IndexShard, ShardRecoveryContext>();
        @Nullable
        private List<ActionListener<Void>> emptyListeners;

        OngoingRecoveries() {
        }

        synchronized RecoverySourceHandler addNewRecovery(StartRecoveryRequest request, IndexShard shard) {
            assert (PeerRecoverySourceService.this.lifecycle.started());
            ShardRecoveryContext shardContext = this.ongoingRecoveries.computeIfAbsent(shard, s -> new ShardRecoveryContext());
            RecoverySourceHandler handler = shardContext.addNewRecovery(request, shard);
            shard.recoveryStats().incCurrentAsSource();
            return handler;
        }

        synchronized void remove(IndexShard shard, RecoverySourceHandler handler) {
            ShardRecoveryContext shardRecoveryContext = this.ongoingRecoveries.get(shard);
            assert (shardRecoveryContext != null) : "Shard was not registered [" + shard + "]";
            boolean remove = shardRecoveryContext.recoveryHandlers.remove(handler);
            assert (remove) : "Handler was not registered [" + handler + "]";
            if (remove) {
                shard.recoveryStats().decCurrentAsSource();
            }
            if (shardRecoveryContext.recoveryHandlers.isEmpty()) {
                this.ongoingRecoveries.remove(shard);
            }
            if (this.ongoingRecoveries.isEmpty() && this.emptyListeners != null) {
                List onEmptyListeners = this.emptyListeners;
                this.emptyListeners = null;
                ActionListener.onResponse(onEmptyListeners, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void cancel(IndexShard shard, String reason) {
            ShardRecoveryContext shardRecoveryContext = this.ongoingRecoveries.get(shard);
            if (shardRecoveryContext != null) {
                ArrayList<Exception> failures = new ArrayList<Exception>();
                for (RecoverySourceHandler handlers : shardRecoveryContext.recoveryHandlers) {
                    try {
                        handlers.cancel(reason);
                    }
                    catch (Exception ex) {
                        failures.add(ex);
                    }
                    finally {
                        shard.recoveryStats().decCurrentAsSource();
                    }
                }
                ExceptionsHelper.maybeThrowRuntimeAndSuppress(failures);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void awaitEmpty() {
            PlainActionFuture future;
            assert (PeerRecoverySourceService.this.lifecycle.stoppedOrClosed());
            OngoingRecoveries ongoingRecoveries = this;
            synchronized (ongoingRecoveries) {
                if (this.ongoingRecoveries.isEmpty()) {
                    return;
                }
                future = new PlainActionFuture();
                if (this.emptyListeners == null) {
                    this.emptyListeners = new ArrayList<ActionListener<Void>>();
                }
                this.emptyListeners.add(future);
            }
            FutureUtils.get(future);
        }

        private final class ShardRecoveryContext {
            final Set<RecoverySourceHandler> recoveryHandlers = new HashSet<RecoverySourceHandler>();

            private ShardRecoveryContext() {
            }

            synchronized RecoverySourceHandler addNewRecovery(StartRecoveryRequest request, IndexShard shard) {
                for (RecoverySourceHandler existingHandler : this.recoveryHandlers) {
                    if (!existingHandler.getRequest().targetAllocationId().equals(request.targetAllocationId())) continue;
                    throw new DelayRecoveryException("recovery with same target already registered, waiting for previous recovery attempt to be cancelled or completed");
                }
                RecoverySourceHandler handler = this.createRecoverySourceHandler(request, shard);
                this.recoveryHandlers.add(handler);
                return handler;
            }

            private RecoverySourceHandler createRecoverySourceHandler(StartRecoveryRequest request, IndexShard shard) {
                RemoteRecoveryTargetHandler recoveryTarget = new RemoteRecoveryTargetHandler(request.recoveryId(), request.shardId(), PeerRecoverySourceService.this.transportService, request.targetNode(), PeerRecoverySourceService.this.recoverySettings, throttleTime -> shard.recoveryStats().addThrottleTime((long)throttleTime));
                RecoverySourceHandler handler = new RecoverySourceHandler(shard, recoveryTarget, shard.getThreadPool(), request, Math.toIntExact(PeerRecoverySourceService.this.recoverySettings.getChunkSize().getBytes()), PeerRecoverySourceService.this.recoverySettings.getMaxConcurrentFileChunks());
                return handler;
            }
        }
    }

    public static class Actions {
        public static final String START_RECOVERY = "internal:index/shard/recovery/start_recovery";
    }

    class StartRecoveryTransportRequestHandler
    implements TransportRequestHandler<StartRecoveryRequest> {
        StartRecoveryTransportRequestHandler() {
        }

        @Override
        public void messageReceived(StartRecoveryRequest request, TransportChannel channel, Task task) throws Exception {
            PeerRecoverySourceService.this.recover(request, new ChannelActionListener(channel, "internal:index/shard/recovery/start_recovery", request));
        }
    }
}

