/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.shard.ShardId;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.store.Store;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportRequest;

public class RecoveryCleanFilesRequest
extends TransportRequest {
    private final long recoveryId;
    private final ShardId shardId;
    private final Store.MetadataSnapshot snapshotFiles;
    private final int totalTranslogOps;
    private final long globalCheckpoint;

    public RecoveryCleanFilesRequest(long recoveryId, ShardId shardId, Store.MetadataSnapshot snapshotFiles, int totalTranslogOps, long globalCheckpoint) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.snapshotFiles = snapshotFiles;
        this.totalTranslogOps = totalTranslogOps;
        this.globalCheckpoint = globalCheckpoint;
    }

    RecoveryCleanFilesRequest(StreamInput in) throws IOException {
        super(in);
        this.recoveryId = in.readLong();
        this.shardId = new ShardId(in);
        this.snapshotFiles = new Store.MetadataSnapshot(in);
        this.totalTranslogOps = in.readVInt();
        this.globalCheckpoint = in.getVersion().onOrAfter(Version.V_7_2_0) ? in.readZLong() : -2L;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        this.snapshotFiles.writeTo(out);
        out.writeVInt(this.totalTranslogOps);
        if (out.getVersion().onOrAfter(Version.V_7_2_0)) {
            out.writeZLong(this.globalCheckpoint);
        }
    }

    public Store.MetadataSnapshot sourceMetaSnapshot() {
        return this.snapshotFiles;
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public int totalTranslogOps() {
        return this.totalTranslogOps;
    }

    public long getGlobalCheckpoint() {
        return this.globalCheckpoint;
    }
}

