/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.ingest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ingest.AbstractProcessor;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ingest.IngestDocument;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ingest.IngestMetric;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ingest.Processor;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ingest.WrappingProcessor;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.DeprecationMap;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.IngestConditionalScript;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.Script;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.ScriptService;

public class ConditionalProcessor
extends AbstractProcessor
implements WrappingProcessor {
    private static final Map<String, String> DEPRECATIONS;
    static final String TYPE = "conditional";
    private final Script condition;
    private final ScriptService scriptService;
    private final Processor processor;
    private final IngestMetric metric;
    private final LongSupplier relativeTimeProvider;

    ConditionalProcessor(String tag, Script script, ScriptService scriptService, Processor processor) {
        this(tag, script, scriptService, processor, System::nanoTime);
    }

    ConditionalProcessor(String tag, Script script, ScriptService scriptService, Processor processor, LongSupplier relativeTimeProvider) {
        super(tag);
        this.condition = script;
        this.scriptService = scriptService;
        this.processor = processor;
        this.metric = new IngestMetric();
        this.relativeTimeProvider = relativeTimeProvider;
    }

    @Override
    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        boolean matches;
        try {
            matches = this.evaluate(ingestDocument);
        }
        catch (Exception e2) {
            handler.accept(null, e2);
            return;
        }
        if (matches) {
            long startTimeInNanos = this.relativeTimeProvider.getAsLong();
            this.metric.preIngest();
            this.processor.execute(ingestDocument, (result, e) -> {
                long ingestTimeInMillis = TimeUnit.NANOSECONDS.toMillis(this.relativeTimeProvider.getAsLong() - startTimeInNanos);
                this.metric.postIngest(ingestTimeInMillis);
                if (e != null) {
                    this.metric.ingestFailed();
                    handler.accept((IngestDocument)null, (Exception)e);
                } else {
                    handler.accept((IngestDocument)result, (Exception)null);
                }
            });
        } else {
            handler.accept(ingestDocument, null);
        }
    }

    @Override
    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        throw new UnsupportedOperationException("this method should not get executed");
    }

    boolean evaluate(IngestDocument ingestDocument) {
        IngestConditionalScript script = this.scriptService.compile(this.condition, IngestConditionalScript.CONTEXT).newInstance(this.condition.getParams());
        return script.execute(new UnmodifiableIngestData(new DeprecationMap(ingestDocument.getSourceAndMetadata(), DEPRECATIONS, "conditional-processor")));
    }

    @Override
    public Processor getInnerProcessor() {
        return this.processor;
    }

    IngestMetric getMetric() {
        return this.metric;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    private static Object wrapUnmodifiable(Object raw) {
        if (raw instanceof Map) {
            return new UnmodifiableIngestData((Map)raw);
        }
        if (raw instanceof List) {
            return new UnmodifiableIngestList((List)raw);
        }
        if (raw instanceof byte[]) {
            return ((byte[])raw).clone();
        }
        return raw;
    }

    private static UnsupportedOperationException unmodifiableException() {
        return new UnsupportedOperationException("Mutating ingest documents in conditionals is not supported");
    }

    static {
        HashMap<String, String> deprecations = new HashMap<String, String>();
        deprecations.put("_type", "[types removal] Looking up doc types [_type] in scripts is deprecated.");
        DEPRECATIONS = Collections.unmodifiableMap(deprecations);
    }

    private static final class UnmodifiableIngestData
    implements Map<String, Object> {
        private final Map<String, Object> data;

        UnmodifiableIngestData(Map<String, Object> data) {
            this.data = data;
        }

        @Override
        public int size() {
            return this.data.size();
        }

        @Override
        public boolean isEmpty() {
            return this.data.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.data.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.data.containsValue(value);
        }

        @Override
        public Object get(Object key) {
            return ConditionalProcessor.wrapUnmodifiable(this.data.get(key));
        }

        @Override
        public Object put(String key, Object value) {
            throw ConditionalProcessor.unmodifiableException();
        }

        @Override
        public Object remove(Object key) {
            throw ConditionalProcessor.unmodifiableException();
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            throw ConditionalProcessor.unmodifiableException();
        }

        @Override
        public void clear() {
            throw ConditionalProcessor.unmodifiableException();
        }

        @Override
        public Set<String> keySet() {
            return Collections.unmodifiableSet(this.data.keySet());
        }

        @Override
        public Collection<Object> values() {
            return new UnmodifiableIngestList(new ArrayList<Object>(this.data.values()));
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.data.entrySet().stream().map(entry -> new Map.Entry<String, Object>(){

                @Override
                public String getKey() {
                    return (String)entry.getKey();
                }

                @Override
                public Object getValue() {
                    return ConditionalProcessor.wrapUnmodifiable(entry.getValue());
                }

                @Override
                public Object setValue(Object value) {
                    throw ConditionalProcessor.unmodifiableException();
                }

                @Override
                public boolean equals(Object o) {
                    return entry.equals(o);
                }

                @Override
                public int hashCode() {
                    return entry.hashCode();
                }
            }).collect(Collectors.toSet());
        }
    }

    private static final class UnmodifiableIngestList
    implements List<Object> {
        private final List<Object> data;

        UnmodifiableIngestList(List<Object> data) {
            this.data = data;
        }

        @Override
        public int size() {
            return this.data.size();
        }

        @Override
        public boolean isEmpty() {
            return this.data.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.data.contains(o);
        }

        @Override
        public Iterator<Object> iterator() {
            final Iterator<Object> wrapped = this.data.iterator();
            return new Iterator<Object>(){

                @Override
                public boolean hasNext() {
                    return wrapped.hasNext();
                }

                @Override
                public Object next() {
                    return wrapped.next();
                }

                @Override
                public void remove() {
                    throw ConditionalProcessor.unmodifiableException();
                }
            };
        }

        @Override
        public Object[] toArray() {
            Object[] wrapped = this.data.toArray(new Object[0]);
            for (int i = 0; i < wrapped.length; ++i) {
                wrapped[i] = ConditionalProcessor.wrapUnmodifiable(wrapped[i]);
            }
            return wrapped;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            Object[] raw = this.data.toArray(new Object[0]);
            T[] wrapped = Arrays.copyOf(raw, a.length, a.getClass());
            for (int i = 0; i < wrapped.length; ++i) {
                wrapped[i] = ConditionalProcessor.wrapUnmodifiable(wrapped[i]);
            }
            return wrapped;
        }

        @Override
        public boolean add(Object o) {
            throw ConditionalProcessor.unmodifiableException();
        }

        @Override
        public boolean remove(Object o) {
            throw ConditionalProcessor.unmodifiableException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.data.contains(c);
        }

        @Override
        public boolean addAll(Collection<?> c) {
            throw ConditionalProcessor.unmodifiableException();
        }

        @Override
        public boolean addAll(int index, Collection<?> c) {
            throw ConditionalProcessor.unmodifiableException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw ConditionalProcessor.unmodifiableException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw ConditionalProcessor.unmodifiableException();
        }

        @Override
        public void clear() {
            throw ConditionalProcessor.unmodifiableException();
        }

        @Override
        public Object get(int index) {
            return ConditionalProcessor.wrapUnmodifiable(this.data.get(index));
        }

        @Override
        public Object set(int index, Object element) {
            throw ConditionalProcessor.unmodifiableException();
        }

        @Override
        public void add(int index, Object element) {
            throw ConditionalProcessor.unmodifiableException();
        }

        @Override
        public Object remove(int index) {
            throw ConditionalProcessor.unmodifiableException();
        }

        @Override
        public int indexOf(Object o) {
            return this.data.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.data.lastIndexOf(o);
        }

        @Override
        public ListIterator<Object> listIterator() {
            return new UnmodifiableListIterator(this.data.listIterator());
        }

        @Override
        public ListIterator<Object> listIterator(int index) {
            return new UnmodifiableListIterator(this.data.listIterator(index));
        }

        @Override
        public List<Object> subList(int fromIndex, int toIndex) {
            return new UnmodifiableIngestList(this.data.subList(fromIndex, toIndex));
        }

        private static final class UnmodifiableListIterator
        implements ListIterator<Object> {
            private final ListIterator<Object> data;

            UnmodifiableListIterator(ListIterator<Object> data) {
                this.data = data;
            }

            @Override
            public boolean hasNext() {
                return this.data.hasNext();
            }

            @Override
            public Object next() {
                return ConditionalProcessor.wrapUnmodifiable(this.data.next());
            }

            @Override
            public boolean hasPrevious() {
                return this.data.hasPrevious();
            }

            @Override
            public Object previous() {
                return ConditionalProcessor.wrapUnmodifiable(this.data.previous());
            }

            @Override
            public int nextIndex() {
                return this.data.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.data.previousIndex();
            }

            @Override
            public void remove() {
                throw ConditionalProcessor.unmodifiableException();
            }

            @Override
            public void set(Object o) {
                throw ConditionalProcessor.unmodifiableException();
            }

            @Override
            public void add(Object o) {
                throw ConditionalProcessor.unmodifiableException();
            }
        }
    }
}

