/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.join.aggregations;

import java.io.IOException;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryShardContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.join.aggregations.InternalChildren;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.join.aggregations.ParentToChildrenAggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregatorFactory;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.internal.SearchContext;

public class ChildrenAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final Query parentFilter;
    private final Query childFilter;

    public ChildrenAggregatorFactory(String name, ValuesSourceConfig config, Query childFilter, Query parentFilter, QueryShardContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.childFilter = childFilter;
        this.parentFilter = parentFilter;
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new NonCollectingAggregator(this.name, searchContext, parent, metadata){

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return new InternalChildren(this.name, 0L, this.buildEmptySubAggregations(), this.metadata());
            }
        };
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource rawValuesSource, SearchContext searchContext, Aggregator parent, boolean collectsFromSingleBucket, Map<String, Object> metadata) throws IOException {
        if (!(rawValuesSource instanceof ValuesSource.Bytes.WithOrdinals)) {
            throw new AggregationExecutionException("ValuesSource type " + rawValuesSource.toString() + "is not supported for aggregation " + this.name());
        }
        ValuesSource.Bytes.WithOrdinals valuesSource = (ValuesSource.Bytes.WithOrdinals)rawValuesSource;
        long maxOrd = valuesSource.globalMaxOrd(searchContext.searcher());
        if (collectsFromSingleBucket) {
            return new ParentToChildrenAggregator(this.name, this.factories, searchContext, parent, this.childFilter, this.parentFilter, valuesSource, maxOrd, metadata);
        }
        return ChildrenAggregatorFactory.asMultiBucketAggregator(this, searchContext, parent);
    }

    @Override
    public String getStatsSubtype() {
        return "other";
    }
}

