/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.join.mapper;

import java.io.IOException;
import java.util.List;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexableField;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.FieldMapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.Mapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.ParseContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.StringFieldType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryShardContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.join.mapper.ParentIdFieldMapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.join.mapper.ParentJoinFieldMapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class MetaJoinFieldMapper
extends FieldMapper {
    static final String NAME = "_parent_join";
    static final String CONTENT_TYPE = "parent_join";

    MetaJoinFieldMapper(String name, MappedFieldType fieldType, Settings indexSettings) {
        super(name, fieldType, ParentIdFieldMapper.Defaults.FIELD_TYPE, indexSettings, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
    }

    void setFieldMapper(ParentJoinFieldMapper mapper) {
        this.fieldType().mapper = mapper;
    }

    @Override
    public MetaJoinFieldType fieldType() {
        return (MetaJoinFieldType)super.fieldType();
    }

    @Override
    protected MetaJoinFieldMapper clone() {
        return (MetaJoinFieldMapper)super.clone();
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        throw new IllegalStateException("Should never be called");
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static class MetaJoinFieldType
    extends StringFieldType {
        private ParentJoinFieldMapper mapper;

        MetaJoinFieldType() {
        }

        protected MetaJoinFieldType(MetaJoinFieldType ref) {
            super(ref);
        }

        @Override
        public MetaJoinFieldType clone() {
            return new MetaJoinFieldType(this);
        }

        @Override
        public String typeName() {
            return MetaJoinFieldMapper.CONTENT_TYPE;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            this.failIfNoDocValues();
            return new DocValuesIndexFieldData.Builder();
        }

        @Override
        public ValuesSourceType getValuesSourceType() {
            return CoreValuesSourceType.BYTES;
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }

        public ParentJoinFieldMapper getMapper() {
            return this.mapper;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            throw new UnsupportedOperationException("Exists query not supported for fields of type" + this.typeName());
        }
    }

    static class Builder
    extends FieldMapper.Builder<Builder, MetaJoinFieldMapper> {
        Builder() {
            super(MetaJoinFieldMapper.NAME, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        @Override
        public MetaJoinFieldMapper build(Mapper.BuilderContext context) {
            this.fieldType.setName(MetaJoinFieldMapper.NAME);
            return new MetaJoinFieldMapper(this.name, this.fieldType, context.indexSettings());
        }
    }

    static class Defaults {
        public static final MappedFieldType FIELD_TYPE = new MetaJoinFieldType();

        Defaults() {
        }

        static {
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setHasDocValues(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.freeze();
        }
    }
}

