/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.repositories;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.repositories.IndexId;

public final class ShardGenerations {
    public static final ShardGenerations EMPTY = new ShardGenerations(Collections.emptyMap());
    public static final String NEW_SHARD_GEN = "_new";
    public static final String DELETED_SHARD_GEN = "_deleted";
    private final Map<IndexId, List<String>> shardGenerations;
    private static final Pattern IS_NUMBER = Pattern.compile("^\\d+$");

    private ShardGenerations(Map<IndexId, List<String>> shardGenerations) {
        this.shardGenerations = shardGenerations;
    }

    @Nullable
    public static String fixShardGeneration(@Nullable String shardGeneration) {
        if (shardGeneration == null) {
            return null;
        }
        return IS_NUMBER.matcher(shardGeneration).matches() ? null : shardGeneration;
    }

    public int totalShards() {
        return this.shardGenerations.values().stream().mapToInt(List::size).sum();
    }

    public Collection<IndexId> indices() {
        return Collections.unmodifiableSet(this.shardGenerations.keySet());
    }

    public Map<IndexId, Map<Integer, String>> obsoleteShardGenerations(ShardGenerations previous) {
        HashMap result = new HashMap();
        previous.shardGenerations.forEach((indexId, oldGens) -> {
            List<String> updatedGenerations = this.shardGenerations.get(indexId);
            HashMap<Integer, String> obsoleteShardIndices = new HashMap<Integer, String>();
            assert (updatedGenerations != null) : "Index [" + indexId + "] present in previous shard generations, but missing from updated generations";
            for (int i = 0; i < Math.min(oldGens.size(), updatedGenerations.size()); ++i) {
                String oldGeneration = (String)oldGens.get(i);
                String updatedGeneration = updatedGenerations.get(i);
                if (updatedGeneration == null || oldGeneration == null || oldGeneration.equals(updatedGeneration)) continue;
                obsoleteShardIndices.put(i, oldGeneration);
            }
            result.put(indexId, Collections.unmodifiableMap(obsoleteShardIndices));
        });
        return Collections.unmodifiableMap(result);
    }

    @Nullable
    public String getShardGen(IndexId indexId, int shardId) {
        List<String> generations = this.shardGenerations.get(indexId);
        if (generations == null || generations.size() < shardId + 1) {
            return null;
        }
        return generations.get(shardId);
    }

    public List<String> getGens(IndexId indexId) {
        List<String> existing = this.shardGenerations.get(indexId);
        return existing == null ? Collections.emptyList() : Collections.unmodifiableList(existing);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardGenerations that = (ShardGenerations)o;
        return this.shardGenerations.equals(that.shardGenerations);
    }

    public int hashCode() {
        return Objects.hash(this.shardGenerations);
    }

    public String toString() {
        return "ShardGenerations{generations:" + this.shardGenerations + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<IndexId, Map<Integer, String>> generations = new HashMap<IndexId, Map<Integer, String>>();

        public Builder retainIndicesAndPruneDeletes(Set<IndexId> indices) {
            this.generations.keySet().retainAll(indices);
            for (IndexId index : indices) {
                Map shards = this.generations.getOrDefault(index, Collections.emptyMap());
                Iterator iterator = shards.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String generation = (String)entry.getValue();
                    if (!generation.equals(ShardGenerations.DELETED_SHARD_GEN)) continue;
                    iterator.remove();
                }
                if (!shards.isEmpty()) continue;
                this.generations.remove(index);
            }
            return this;
        }

        public Builder putAll(ShardGenerations shardGenerations) {
            shardGenerations.shardGenerations.forEach((indexId, gens) -> {
                for (int i = 0; i < gens.size(); ++i) {
                    String gen = (String)gens.get(i);
                    if (gen == null) continue;
                    this.put((IndexId)indexId, i, (String)gens.get(i));
                }
            });
            return this;
        }

        public Builder put(IndexId indexId, int shardId, String generation) {
            this.generations.computeIfAbsent(indexId, i -> new HashMap()).put(shardId, generation);
            return this;
        }

        public ShardGenerations build() {
            return new ShardGenerations(this.generations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                Set shardIds = ((Map)entry.getValue()).keySet();
                assert (!shardIds.isEmpty());
                int size = shardIds.stream().mapToInt(i -> i).max().getAsInt() + 1;
                String[] gens = new String[size];
                ((Map)entry.getValue()).forEach((shardId, generation) -> {
                    gens[shardId.intValue()] = generation;
                });
                return Arrays.asList(gens);
            })));
        }
    }
}

