/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.datastream.CreateDataStreamAction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.DataStream;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestChannel;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.action.RestToXContentListener;

public class RestCreateDataStreamAction
extends BaseRestHandler {
    @Override
    public String getName() {
        return "create_data_stream_action";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.PUT, "/_data_stream/{name}"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        CreateDataStreamAction.Request putDataStreamRequest = new CreateDataStreamAction.Request(request.param("name"));
        request.withContentOrSourceParamParserOrNull(parser -> {
            Map<String, Object> body;
            String timeStampFieldName;
            if (parser != null && (timeStampFieldName = (String)(body = parser.map()).get(DataStream.TIMESTAMP_FIELD_FIELD.getPreferredName())) != null) {
                putDataStreamRequest.setTimestampFieldName(timeStampFieldName);
            }
        });
        return channel -> client.admin().indices().createDataStream(putDataStreamRequest, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
    }
}

