/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.script;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;

public class ScriptStats
implements Writeable,
ToXContentFragment {
    private final long compilations;
    private final long cacheEvictions;
    private final long compilationLimitTriggered;

    public ScriptStats(long compilations, long cacheEvictions, long compilationLimitTriggered) {
        this.compilations = compilations;
        this.cacheEvictions = cacheEvictions;
        this.compilationLimitTriggered = compilationLimitTriggered;
    }

    public ScriptStats(StreamInput in) throws IOException {
        this.compilations = in.readVLong();
        this.cacheEvictions = in.readVLong();
        this.compilationLimitTriggered = in.getVersion().onOrAfter(Version.V_7_0_0) ? in.readVLong() : 0L;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.compilations);
        out.writeVLong(this.cacheEvictions);
        if (out.getVersion().onOrAfter(Version.V_7_0_0)) {
            out.writeVLong(this.compilationLimitTriggered);
        }
    }

    public long getCompilations() {
        return this.compilations;
    }

    public long getCacheEvictions() {
        return this.cacheEvictions;
    }

    public long getCompilationLimitTriggered() {
        return this.compilationLimitTriggered;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("script");
        builder.field("compilations", this.getCompilations());
        builder.field("cache_evictions", this.getCacheEvictions());
        builder.field("compilation_limit_triggered", this.getCompilationLimitTriggered());
        builder.endObject();
        return builder;
    }

    public static ScriptStats sum(Iterable<ScriptStats> stats) {
        long compilations = 0L;
        long cacheEvictions = 0L;
        long compilationLimitTriggered = 0L;
        for (ScriptStats stat : stats) {
            compilations += stat.compilations;
            cacheEvictions += stat.cacheEvictions;
            compilationLimitTriggered += stat.compilationLimitTriggered;
        }
        return new ScriptStats(compilations, cacheEvictions, compilationLimitTriggered);
    }

    static final class Fields {
        static final String SCRIPT_STATS = "script";
        static final String COMPILATIONS = "compilations";
        static final String CACHE_EVICTIONS = "cache_evictions";
        static final String COMPILATION_LIMIT_TRIGGERED = "compilation_limit_triggered";

        Fields() {
        }
    }
}

