/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.script.mustache;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.logging.DeprecationLogger;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestChannel;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.action.RestToXContentListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.action.search.RestMultiSearchAction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.action.search.RestSearchAction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.mustache.MultiSearchTemplateAction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.mustache.MultiSearchTemplateRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.mustache.SearchTemplateRequest;

public class RestMultiSearchTemplateAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestMultiSearchTemplateAction.class));
    static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Specifying types in multi search template requests is deprecated.";
    private static final Set<String> RESPONSE_PARAMS;
    private final boolean allowExplicitIndex;

    public RestMultiSearchTemplateAction(Settings settings) {
        this.allowExplicitIndex = (Boolean)MULTI_ALLOW_EXPLICIT_INDEX.get(settings);
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_msearch/template"), new RestHandler.Route(RestRequest.Method.POST, "/_msearch/template"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_msearch/template"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_msearch/template"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/{type}/_msearch/template"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/{type}/_msearch/template")));
    }

    @Override
    public String getName() {
        return "multi_search_template_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MultiSearchTemplateRequest multiRequest = RestMultiSearchTemplateAction.parseRequest(request, this.allowExplicitIndex);
        for (SearchTemplateRequest searchTemplateRequest : multiRequest.requests()) {
            if (searchTemplateRequest.getRequest().types().length <= 0) continue;
            deprecationLogger.deprecatedAndMaybeLog("msearch_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
            break;
        }
        return channel -> client.execute(MultiSearchTemplateAction.INSTANCE, multiRequest, new RestToXContentListener((RestChannel)channel));
    }

    public static MultiSearchTemplateRequest parseRequest(RestRequest restRequest, boolean allowExplicitIndex) throws IOException {
        MultiSearchTemplateRequest multiRequest = new MultiSearchTemplateRequest();
        if (restRequest.hasParam("max_concurrent_searches")) {
            multiRequest.maxConcurrentSearchRequests(restRequest.paramAsInt("max_concurrent_searches", 0));
        }
        RestMultiSearchAction.parseMultiLineRequest(restRequest, multiRequest.indicesOptions(), allowExplicitIndex, (searchRequest, bytes) -> {
            SearchTemplateRequest searchTemplateRequest = SearchTemplateRequest.fromXContent(bytes);
            if (searchTemplateRequest.getScript() == null) {
                throw new IllegalArgumentException("Malformed search template");
            }
            searchTemplateRequest.setRequest((SearchRequest)searchRequest);
            multiRequest.add(searchTemplateRequest);
            RestSearchAction.checkRestTotalHits(restRequest, searchRequest);
        });
        return multiRequest;
    }

    @Override
    public boolean supportsContentStream() {
        return true;
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    static {
        HashSet<String> responseParams = new HashSet<String>(Arrays.asList("typed_keys", "rest_total_hits_as_int"));
        RESPONSE_PARAMS = Collections.unmodifiableSet(responseParams);
    }
}

