/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.script.mustache;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestChannel;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.action.RestToXContentListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.ScriptType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.mustache.SearchTemplateAction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.mustache.SearchTemplateRequest;

public class RestRenderSearchTemplateAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_render/template"), new RestHandler.Route(RestRequest.Method.POST, "/_render/template"), new RestHandler.Route(RestRequest.Method.GET, "/_render/template/{id}"), new RestHandler.Route(RestRequest.Method.POST, "/_render/template/{id}")));
    }

    @Override
    public String getName() {
        return "render_search_template_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        SearchTemplateRequest renderRequest;
        try (XContentParser parser = request.contentOrSourceParamParser();){
            renderRequest = SearchTemplateRequest.fromXContent(parser);
        }
        renderRequest.setSimulate(true);
        String id = request.param("id");
        if (id != null) {
            renderRequest.setScriptType(ScriptType.STORED);
            renderRequest.setScript(id);
        }
        return channel -> client.execute(SearchTemplateAction.INSTANCE, renderRequest, new RestToXContentListener((RestChannel)channel));
    }
}

