/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Scorable;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lease.Releasables;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.BigArrays;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.ObjectArray;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryShardContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.internal.SearchContext;

public abstract class AggregatorFactory {
    protected final String name;
    protected final AggregatorFactory parent;
    protected final AggregatorFactories factories;
    protected final Map<String, Object> metadata;
    protected final QueryShardContext queryShardContext;

    public AggregatorFactory(String name, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        this.name = name;
        this.queryShardContext = queryShardContext;
        this.parent = parent;
        this.factories = subFactoriesBuilder.build(queryShardContext, this);
        this.metadata = metadata;
    }

    public String name() {
        return this.name;
    }

    public void doValidate() {
    }

    protected abstract Aggregator createInternal(SearchContext var1, Aggregator var2, boolean var3, Map<String, Object> var4) throws IOException;

    public final Aggregator create(SearchContext searchContext, Aggregator parent, boolean collectsFromSingleBucket) throws IOException {
        return this.createInternal(searchContext, parent, collectsFromSingleBucket, this.metadata);
    }

    public AggregatorFactory getParent() {
        return this.parent;
    }

    protected static Aggregator asMultiBucketAggregator(AggregatorFactory factory, SearchContext searchContext, Aggregator parent) throws IOException {
        Aggregator first = factory.create(searchContext, parent, true);
        BigArrays bigArrays = searchContext.bigArrays();
        return new MultiBucketAggregatorWrapper(bigArrays, searchContext, parent, factory, first);
    }

    public String getStatsSubtype() {
        return "other";
    }

    public static final class MultiBucketAggregatorWrapper
    extends Aggregator {
        private final BigArrays bigArrays;
        private final Aggregator parent;
        private final AggregatorFactory factory;
        private final Aggregator first;
        ObjectArray<Aggregator> aggregators;
        ObjectArray<LeafBucketCollector> collectors;

        MultiBucketAggregatorWrapper(BigArrays bigArrays, SearchContext context, Aggregator parent, AggregatorFactory factory, Aggregator first) {
            this.bigArrays = bigArrays;
            this.parent = parent;
            this.factory = factory;
            this.first = first;
            context.addReleasable(this, SearchContext.Lifetime.PHASE);
            this.aggregators = bigArrays.newObjectArray(1L);
            this.aggregators.set(0L, first);
            this.collectors = bigArrays.newObjectArray(1L);
        }

        public Class<?> getWrappedClass() {
            return this.first.getClass();
        }

        @Override
        public String name() {
            return this.first.name();
        }

        @Override
        public SearchContext context() {
            return this.first.context();
        }

        @Override
        public Aggregator parent() {
            return this.first.parent();
        }

        @Override
        public ScoreMode scoreMode() {
            return this.first.scoreMode();
        }

        @Override
        public Aggregator subAggregator(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void preCollection() throws IOException {
            for (long i = 0L; i < this.aggregators.size(); ++i) {
                Aggregator aggregator = this.aggregators.get(i);
                if (aggregator == null) continue;
                aggregator.preCollection();
            }
        }

        @Override
        public void postCollection() throws IOException {
            for (long i = 0L; i < this.aggregators.size(); ++i) {
                Aggregator aggregator = this.aggregators.get(i);
                if (aggregator == null) continue;
                aggregator.postCollection();
            }
        }

        @Override
        public LeafBucketCollector getLeafCollector(final LeafReaderContext ctx) {
            for (long i = 0L; i < this.collectors.size(); ++i) {
                this.collectors.set(i, null);
            }
            return new LeafBucketCollector(){
                Scorable scorer;

                @Override
                public void setScorer(Scorable scorer) throws IOException {
                    this.scorer = scorer;
                }

                @Override
                public void collect(int doc, long bucket) throws IOException {
                    collectors = bigArrays.grow(collectors, bucket + 1L);
                    LeafBucketCollector collector = collectors.get(bucket);
                    if (collector == null) {
                        aggregators = bigArrays.grow(aggregators, bucket + 1L);
                        Aggregator aggregator = aggregators.get(bucket);
                        if (aggregator == null) {
                            aggregator = factory.create(this.context(), parent, true);
                            aggregator.preCollection();
                            aggregators.set(bucket, aggregator);
                        }
                        collector = aggregator.getLeafCollector(ctx);
                        if (this.scorer != null) {
                            collector.setScorer(this.scorer);
                        }
                        collectors.set(bucket, collector);
                    }
                    collector.collect(doc, 0L);
                }
            };
        }

        @Override
        public InternalAggregation buildAggregation(long bucket) throws IOException {
            Aggregator aggregator;
            if (bucket < this.aggregators.size() && (aggregator = this.aggregators.get(bucket)) != null) {
                return aggregator.buildAggregation(0L);
            }
            return this.buildEmptyAggregation();
        }

        @Override
        public InternalAggregation buildEmptyAggregation() {
            return this.first.buildEmptyAggregation();
        }

        @Override
        public void close() {
            Releasables.close(this.aggregators, this.collectors);
        }
    }
}

