/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.CollectionTerminatedException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.MatchAllDocsQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Scorer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Weight;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.packed.PackedLongValues;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.BigArrays;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.LongHash;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.BucketCollector;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.MultiBucketCollector;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.DeferringBucketCollector;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.internal.SearchContext;

public class BestBucketsDeferringCollector
extends DeferringBucketCollector {
    protected List<Entry> entries = new ArrayList<Entry>();
    protected BucketCollector collector;
    protected final SearchContext searchContext;
    protected final boolean isGlobal;
    protected LeafReaderContext context;
    protected PackedLongValues.Builder docDeltasBuilder;
    protected PackedLongValues.Builder bucketsBuilder;
    protected long maxBucket = -1L;
    protected boolean finished = false;
    protected LongHash selectedBuckets;

    public BestBucketsDeferringCollector(SearchContext context, boolean isGlobal) {
        this.searchContext = context;
        this.isGlobal = isGlobal;
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.collector == null) {
            throw new IllegalStateException();
        }
        return this.collector.scoreMode();
    }

    @Override
    public void setDeferredCollector(Iterable<BucketCollector> deferredCollectors) {
        this.collector = MultiBucketCollector.wrap(deferredCollectors);
    }

    private void finishLeaf() {
        if (this.context != null) {
            assert (this.docDeltasBuilder != null && this.bucketsBuilder != null);
            this.entries.add(new Entry(this.context, this.docDeltasBuilder.build(), this.bucketsBuilder.build()));
        }
    }

    @Override
    public LeafBucketCollector getLeafCollector(final LeafReaderContext ctx) throws IOException {
        this.finishLeaf();
        this.context = null;
        this.docDeltasBuilder = null;
        this.bucketsBuilder = null;
        return new LeafBucketCollector(){
            int lastDoc = 0;

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (BestBucketsDeferringCollector.this.context == null) {
                    BestBucketsDeferringCollector.this.context = ctx;
                    BestBucketsDeferringCollector.this.docDeltasBuilder = PackedLongValues.packedBuilder(0.25f);
                    BestBucketsDeferringCollector.this.bucketsBuilder = PackedLongValues.packedBuilder(0.25f);
                }
                BestBucketsDeferringCollector.this.docDeltasBuilder.add(doc - this.lastDoc);
                BestBucketsDeferringCollector.this.bucketsBuilder.add(bucket);
                this.lastDoc = doc;
                BestBucketsDeferringCollector.this.maxBucket = Math.max(BestBucketsDeferringCollector.this.maxBucket, bucket);
            }
        };
    }

    @Override
    public void preCollection() throws IOException {
        this.collector.preCollection();
    }

    @Override
    public void postCollection() throws IOException {
        this.finishLeaf();
        this.finished = true;
    }

    @Override
    public void prepareSelectedBuckets(long ... selectedBuckets) throws IOException {
        if (!this.finished) {
            throw new IllegalStateException("Cannot replay yet, collection is not finished: postCollect() has not been called");
        }
        if (this.selectedBuckets != null) {
            throw new IllegalStateException("Already been replayed");
        }
        LongHash hash = new LongHash(selectedBuckets.length, BigArrays.NON_RECYCLING_INSTANCE);
        for (long bucket : selectedBuckets) {
            hash.add(bucket);
        }
        this.selectedBuckets = hash;
        boolean needsScores = this.scoreMode().needsScores();
        Weight weight = null;
        if (needsScores) {
            Query query = this.isGlobal ? new MatchAllDocsQuery() : this.searchContext.query();
            weight = this.searchContext.searcher().createWeight(this.searchContext.searcher().rewrite(query), ScoreMode.COMPLETE, 1.0f);
        }
        for (Entry entry : this.entries) {
            assert (entry.docDeltas.size() > 0L) : "segment should have at least one document to replay, got 0";
            try {
                LeafBucketCollector leafCollector = this.collector.getLeafCollector(entry.context);
                DocIdSetIterator scoreIt = null;
                if (needsScores) {
                    Scorer scorer = weight.scorer(entry.context);
                    scoreIt = scorer.iterator();
                    leafCollector.setScorer(scorer);
                }
                PackedLongValues.Iterator docDeltaIterator = entry.docDeltas.iterator();
                PackedLongValues.Iterator buckets = entry.buckets.iterator();
                int doc = 0;
                long end = entry.docDeltas.size();
                for (long i = 0L; i < end; ++i) {
                    doc = (int)((long)doc + docDeltaIterator.next());
                    long bucket = buckets.next();
                    long rebasedBucket = hash.find(bucket);
                    if (rebasedBucket == -1L) continue;
                    if (needsScores) {
                        if (scoreIt.docID() < doc) {
                            scoreIt.advance(doc);
                        }
                        assert (scoreIt.docID() == doc);
                    }
                    leafCollector.collect(doc, rebasedBucket);
                }
            }
            catch (CollectionTerminatedException collectionTerminatedException) {
            }
        }
        this.collector.postCollection();
    }

    @Override
    public Aggregator wrap(final Aggregator in) {
        return new DeferringBucketCollector.WrappedAggregator(in){

            @Override
            public InternalAggregation buildAggregation(long bucket) throws IOException {
                if (BestBucketsDeferringCollector.this.selectedBuckets == null) {
                    throw new IllegalStateException("Collection has not been replayed yet.");
                }
                long rebasedBucket = BestBucketsDeferringCollector.this.selectedBuckets.find(bucket);
                if (rebasedBucket == -1L) {
                    throw new IllegalStateException("Cannot build for a bucket which has not been collected");
                }
                return in.buildAggregation(rebasedBucket);
            }
        };
    }

    static class Entry {
        final LeafReaderContext context;
        final PackedLongValues docDeltas;
        final PackedLongValues buckets;

        Entry(LeafReaderContext context, PackedLongValues docDeltas, PackedLongValues buckets) {
            this.context = Objects.requireNonNull(context);
            this.docDeltas = Objects.requireNonNull(docDeltas);
            this.buckets = Objects.requireNonNull(buckets);
        }
    }
}

