/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.function.IntConsumer;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.BigArrays;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.IntArray;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregatorBase;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.InternalAggregations;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.AggregationPath;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.internal.SearchContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.sort.SortOrder;

public abstract class BucketsAggregator
extends AggregatorBase {
    private final BigArrays bigArrays;
    private final IntConsumer multiBucketConsumer;
    private IntArray docCounts;

    public BucketsAggregator(String name, AggregatorFactories factories, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, metadata);
        this.bigArrays = context.bigArrays();
        this.docCounts = this.bigArrays.newIntArray(1L, true);
        this.multiBucketConsumer = context.aggregations() != null ? context.aggregations().multiBucketConsumer() : count -> {};
    }

    public final long maxBucketOrd() {
        return this.docCounts.size();
    }

    public final void grow(long maxBucketOrd) {
        this.docCounts = this.bigArrays.grow(this.docCounts, maxBucketOrd);
    }

    public final void collectBucket(LeafBucketCollector subCollector, int doc, long bucketOrd) throws IOException {
        this.grow(bucketOrd + 1L);
        this.collectExistingBucket(subCollector, doc, bucketOrd);
    }

    public final void collectExistingBucket(LeafBucketCollector subCollector, int doc, long bucketOrd) throws IOException {
        this.docCounts.increment(bucketOrd, 1);
        subCollector.collect(doc, bucketOrd);
    }

    public final void mergeBuckets(long[] mergeMap, long newNumBuckets) {
        try (IntArray oldDocCounts = this.docCounts;){
            this.docCounts = this.bigArrays.newIntArray(newNumBuckets, true);
            this.docCounts.fill(0L, newNumBuckets, 0);
            int i = 0;
            while ((long)i < oldDocCounts.size()) {
                int docCount = oldDocCounts.get(i);
                if (docCount != 0 && mergeMap[i] != -1L) {
                    this.docCounts.increment(mergeMap[i], docCount);
                }
                ++i;
            }
        }
    }

    public IntArray getDocCounts() {
        return this.docCounts;
    }

    public final void incrementBucketDocCount(long bucketOrd, int inc) {
        this.docCounts = this.bigArrays.grow(this.docCounts, bucketOrd + 1L);
        this.docCounts.increment(bucketOrd, inc);
    }

    public final int bucketDocCount(long bucketOrd) {
        if (bucketOrd >= this.docCounts.size()) {
            return 0;
        }
        return this.docCounts.get(bucketOrd);
    }

    protected final void consumeBucketsAndMaybeBreak(int count) {
        this.multiBucketConsumer.accept(count);
    }

    protected final InternalAggregations bucketAggregations(long bucket) throws IOException {
        InternalAggregation[] aggregations = new InternalAggregation[this.subAggregators.length];
        for (int i = 0; i < this.subAggregators.length; ++i) {
            aggregations[i] = this.subAggregators[i].buildAggregation(bucket);
        }
        return new InternalAggregations(Arrays.asList(aggregations));
    }

    protected final InternalAggregations bucketEmptyAggregations() {
        InternalAggregation[] aggregations = new InternalAggregation[this.subAggregators.length];
        for (int i = 0; i < this.subAggregators.length; ++i) {
            aggregations[i] = this.subAggregators[i].buildEmptyAggregation();
        }
        return new InternalAggregations(Arrays.asList(aggregations));
    }

    @Override
    public final void close() {
        try (IntArray releasable = this.docCounts;){
            super.close();
        }
    }

    @Override
    public Aggregator resolveSortPath(AggregationPath.PathElement next, Iterator<AggregationPath.PathElement> path) {
        if (this instanceof SingleBucketAggregator) {
            return this.resolveSortPathOnValidAgg(next, path);
        }
        return super.resolveSortPath(next, path);
    }

    @Override
    public Aggregator.BucketComparator bucketComparator(String key, SortOrder order) {
        if (key == null || "doc_count".equals(key)) {
            return (lhs, rhs) -> order.reverseMul() * Integer.compare(this.bucketDocCount(lhs), this.bucketDocCount(rhs));
        }
        throw new IllegalArgumentException("Ordering on a single-bucket aggregation can only be done on its doc_count. Either drop the key (a la \"" + this.name() + "\") or change it to \"doc_count\" (a la \"" + this.name() + ".doc_count\") or \"key\".");
    }
}

