/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.SortedNumericDocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lease.Releasables;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.LongHash;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.geogrid.BucketPriorityQueue;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoGrid;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoGridBucket;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.internal.SearchContext;

public abstract class GeoGridAggregator<T extends InternalGeoGrid>
extends BucketsAggregator {
    protected final int requiredSize;
    protected final int shardSize;
    protected final ValuesSource.Numeric valuesSource;
    protected final LongHash bucketOrds;
    protected SortedNumericDocValues values;

    GeoGridAggregator(String name, AggregatorFactories factories, ValuesSource.Numeric valuesSource, int requiredSize, int shardSize, SearchContext aggregationContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, factories, aggregationContext, parent, metadata);
        this.valuesSource = valuesSource;
        this.requiredSize = requiredSize;
        this.shardSize = shardSize;
        this.bucketOrds = new LongHash(1L, aggregationContext.bigArrays());
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.valuesSource != null && this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        this.values = this.valuesSource.longValues(ctx);
        return new LeafBucketCollectorBase(sub, null){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                assert (bucket == 0L);
                if (GeoGridAggregator.this.values.advanceExact(doc)) {
                    int valuesCount = GeoGridAggregator.this.values.docValueCount();
                    long previous = Long.MAX_VALUE;
                    for (int i = 0; i < valuesCount; ++i) {
                        long val = GeoGridAggregator.this.values.nextValue();
                        if (previous == val && i != 0) continue;
                        long bucketOrdinal = GeoGridAggregator.this.bucketOrds.add(val);
                        if (bucketOrdinal < 0L) {
                            bucketOrdinal = -1L - bucketOrdinal;
                            GeoGridAggregator.this.collectExistingBucket(sub, doc, bucketOrdinal);
                        } else {
                            GeoGridAggregator.this.collectBucket(sub, doc, bucketOrdinal);
                        }
                        previous = val;
                    }
                }
            }
        };
    }

    abstract T buildAggregation(String var1, int var2, List<InternalGeoGridBucket> var3, Map<String, Object> var4);

    abstract InternalGeoGridBucket newEmptyBucket();

    @Override
    public InternalGeoGrid buildAggregation(long owningBucketOrdinal) throws IOException {
        assert (owningBucketOrdinal == 0L);
        int size = (int)Math.min(this.bucketOrds.size(), (long)this.shardSize);
        this.consumeBucketsAndMaybeBreak(size);
        BucketPriorityQueue ordered = new BucketPriorityQueue(size);
        InternalGeoGridBucket spare = null;
        long i = 0L;
        while (i < this.bucketOrds.size()) {
            if (spare == null) {
                spare = this.newEmptyBucket();
            }
            spare.hashAsLong = this.bucketOrds.get(i);
            spare.docCount = this.bucketDocCount(i);
            spare.bucketOrd = i++;
            spare = ordered.insertWithOverflow(spare);
        }
        InternalGeoGridBucket[] list = new InternalGeoGridBucket[ordered.size()];
        for (int i2 = ordered.size() - 1; i2 >= 0; --i2) {
            InternalGeoGridBucket bucket = (InternalGeoGridBucket)ordered.pop();
            bucket.aggregations = this.bucketAggregations(bucket.bucketOrd);
            list[i2] = bucket;
        }
        return this.buildAggregation(this.name, this.requiredSize, Arrays.asList(list), this.metadata());
    }

    @Override
    public InternalGeoGrid buildEmptyAggregation() {
        return this.buildAggregation(this.name, this.requiredSize, Collections.emptyList(), this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close(this.bucketOrds);
    }
}

