/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.global;

import java.io.IOException;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.global.InternalGlobal;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.internal.SearchContext;

public class GlobalAggregator
extends BucketsAggregator
implements SingleBucketAggregator {
    public GlobalAggregator(String name, AggregatorFactories subFactories, SearchContext aggregationContext, Map<String, Object> metadata) throws IOException {
        super(name, subFactories, aggregationContext, null, metadata);
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        return new LeafBucketCollectorBase(sub, null){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                assert (bucket == 0L) : "global aggregator can only be a top level aggregator";
                GlobalAggregator.this.collectBucket(sub, doc, bucket);
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        assert (owningBucketOrdinal == 0L) : "global aggregator can only be a top level aggregator";
        return new InternalGlobal(this.name, this.bucketDocCount(owningBucketOrdinal), this.bucketAggregations(owningBucketOrdinal), this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        throw new UnsupportedOperationException("global aggregations cannot serve as sub-aggregations, hence should never be called on #buildEmptyAggregations");
    }
}

