/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryShardContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregatorFactory;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.histogram.AutoDateHistogramAggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.histogram.AutoDateHistogramAggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.histogram.AutoDateHistogramAggregatorSupplier;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.AggregatorSupplier;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.internal.SearchContext;

public final class AutoDateHistogramAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final int numBuckets;
    private AutoDateHistogramAggregationBuilder.RoundingInfo[] roundingInfos;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register("auto_date_histogram", Arrays.asList(CoreValuesSourceType.DATE, CoreValuesSourceType.NUMERIC, CoreValuesSourceType.BOOLEAN), AutoDateHistogramAggregator::new);
    }

    public AutoDateHistogramAggregatorFactory(String name, ValuesSourceConfig config, int numBuckets, AutoDateHistogramAggregationBuilder.RoundingInfo[] roundingInfos, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.numBuckets = numBuckets;
        this.roundingInfos = roundingInfos;
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource valuesSource, SearchContext searchContext, Aggregator parent, boolean collectsFromSingleBucket, Map<String, Object> metadata) throws IOException {
        if (!collectsFromSingleBucket) {
            return AutoDateHistogramAggregatorFactory.asMultiBucketAggregator(this, searchContext, parent);
        }
        AggregatorSupplier aggregatorSupplier = this.queryShardContext.getValuesSourceRegistry().getAggregator(this.config.valueSourceType(), "auto_date_histogram");
        if (!(aggregatorSupplier instanceof AutoDateHistogramAggregatorSupplier)) {
            throw new AggregationExecutionException("Registry miss-match - expected AutoDateHistogramAggregationSupplier, found [" + aggregatorSupplier.getClass().toString() + "]");
        }
        return ((AutoDateHistogramAggregatorSupplier)aggregatorSupplier).build(this.name, this.factories, this.numBuckets, this.roundingInfos, valuesSource, this.config.format(), searchContext, parent, metadata);
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new AutoDateHistogramAggregator(this.name, this.factories, this.numBuckets, this.roundingInfos, null, this.config.format(), searchContext, parent, metadata);
    }
}

