/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lease.Releasables;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.DocValueFormat;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.significant.BucketSignificancePriorityQueue;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.significant.SignificantLongTerms;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.significant.SignificantTermsAggregatorFactory;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms.LongTermsAggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.internal.ContextIndexSearcher;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.internal.SearchContext;

public class SignificantLongTermsAggregator
extends LongTermsAggregator {
    protected long numCollectedDocs;
    private final SignificantTermsAggregatorFactory termsAggFactory;
    private final SignificanceHeuristic significanceHeuristic;

    public SignificantLongTermsAggregator(String name, AggregatorFactories factories, ValuesSource.Numeric valuesSource, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, SearchContext context, Aggregator parent, SignificanceHeuristic significanceHeuristic, SignificantTermsAggregatorFactory termsAggFactory, IncludeExclude.LongFilter includeExclude, Map<String, Object> metadata) throws IOException {
        super(name, factories, valuesSource, format, null, bucketCountThresholds, context, parent, Aggregator.SubAggCollectionMode.BREADTH_FIRST, false, includeExclude, metadata);
        this.significanceHeuristic = significanceHeuristic;
        this.termsAggFactory = termsAggFactory;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        return new LeafBucketCollectorBase(super.getLeafCollector(ctx, sub), null){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                super.collect(doc, bucket);
                ++SignificantLongTermsAggregator.this.numCollectedDocs;
            }
        };
    }

    @Override
    public SignificantLongTerms buildAggregation(long owningBucketOrdinal) throws IOException {
        assert (owningBucketOrdinal == 0L);
        int size = (int)Math.min(this.bucketOrds.size(), (long)this.bucketCountThresholds.getShardSize());
        long supersetSize = this.termsAggFactory.getSupersetNumDocs();
        long subsetSize = this.numCollectedDocs;
        BucketSignificancePriorityQueue ordered = new BucketSignificancePriorityQueue(size);
        SignificantLongTerms.Bucket spare = null;
        for (long i = 0L; i < this.bucketOrds.size(); ++i) {
            int docCount = this.bucketDocCount(i);
            if ((long)docCount < this.bucketCountThresholds.getShardMinDocCount()) continue;
            if (spare == null) {
                spare = new SignificantLongTerms.Bucket(0L, 0L, 0L, 0L, 0L, null, this.format, 0.0);
            }
            spare.term = this.bucketOrds.get(i);
            spare.subsetDf = docCount;
            spare.subsetSize = subsetSize;
            spare.supersetDf = this.termsAggFactory.getBackgroundFrequency(spare.term);
            spare.supersetSize = supersetSize;
            spare.updateScore(this.significanceHeuristic);
            spare.bucketOrd = i;
            spare = ordered.insertWithOverflow(spare);
            if (spare != null) continue;
            this.consumeBucketsAndMaybeBreak(1);
        }
        SignificantLongTerms.Bucket[] list = new SignificantLongTerms.Bucket[ordered.size()];
        long[] survivingBucketOrds = new long[ordered.size()];
        for (int i = ordered.size() - 1; i >= 0; --i) {
            SignificantLongTerms.Bucket bucket = (SignificantLongTerms.Bucket)ordered.pop();
            survivingBucketOrds[i] = bucket.bucketOrd;
            list[i] = bucket;
        }
        this.runDeferredCollections(survivingBucketOrds);
        for (SignificantLongTerms.Bucket bucket : list) {
            bucket.aggregations = this.bucketAggregations(bucket.bucketOrd);
        }
        return new SignificantLongTerms(this.name, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.metadata(), this.format, subsetSize, supersetSize, this.significanceHeuristic, Arrays.asList(list));
    }

    @Override
    public SignificantLongTerms buildEmptyAggregation() {
        ContextIndexSearcher searcher = this.context.searcher();
        IndexReader topReader = searcher.getIndexReader();
        int supersetSize = topReader.numDocs();
        return new SignificantLongTerms(this.name, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.metadata(), this.format, 0L, (long)supersetSize, this.significanceHeuristic, Collections.emptyList());
    }

    @Override
    public void doClose() {
        Releasables.close(this.bucketOrds, this.termsAggFactory);
    }
}

