/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.Term;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.BooleanClause;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.BooleanQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.TermQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lease.Releasable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.logging.DeprecationLogger;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lucene.index.FilterableTermsEnum;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lucene.index.FreqTermsEnum;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryShardContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.DocValueFormat;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregatorFactory;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.BucketUtils;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.significant.GlobalOrdinalsSignificantTermsAggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.significant.SignificantLongTermsAggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.significant.SignificantStringTermsAggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.significant.SignificantTermsAggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.significant.SignificantTermsAggregatorSupplier;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.significant.UnmappedSignificantTerms;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.AggregatorSupplier;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.internal.SearchContext;

public class SignificantTermsAggregatorFactory
extends ValuesSourceAggregatorFactory
implements Releasable {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(SignificantTermsAggregatorFactory.class));
    private final IncludeExclude includeExclude;
    private final String executionHint;
    private String indexedFieldName;
    private MappedFieldType fieldType;
    private FilterableTermsEnum termsEnum;
    private int numberOfAggregatorsCreated;
    final Query filter;
    private final int supersetNumDocs;
    private final TermsAggregator.BucketCountThresholds bucketCountThresholds;
    private final SignificanceHeuristic significanceHeuristic;

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register("significant_terms", Arrays.asList(CoreValuesSourceType.BYTES, CoreValuesSourceType.IP), (AggregatorSupplier)SignificantTermsAggregatorFactory.bytesSupplier());
        builder.register("significant_terms", Arrays.asList(CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN, CoreValuesSourceType.NUMERIC), (AggregatorSupplier)SignificantTermsAggregatorFactory.numericSupplier());
    }

    private static SignificantTermsAggregatorSupplier bytesSupplier() {
        return new SignificantTermsAggregatorSupplier(){

            @Override
            public Aggregator build(String name, AggregatorFactories factories, ValuesSource valuesSource, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, String executionHint, SearchContext context, Aggregator parent, SignificanceHeuristic significanceHeuristic, SignificantTermsAggregatorFactory sigTermsFactory, Map<String, Object> metadata) throws IOException {
                ExecutionMode execution = null;
                if (executionHint != null) {
                    execution = ExecutionMode.fromString(executionHint, deprecationLogger);
                }
                if (!(valuesSource instanceof ValuesSource.Bytes.WithOrdinals)) {
                    execution = ExecutionMode.MAP;
                }
                if (execution == null) {
                    execution = ExecutionMode.GLOBAL_ORDINALS;
                }
                if (includeExclude != null && includeExclude.isRegexBased() && format != DocValueFormat.RAW) {
                    throw new IllegalArgumentException("Aggregation [" + name + "] cannot support regular expression style include/exclude settings as they can only be applied to string fields. Use an array of values for include/exclude clauses");
                }
                return execution.create(name, factories, valuesSource, format, bucketCountThresholds, includeExclude, context, parent, significanceHeuristic, sigTermsFactory, metadata);
            }
        };
    }

    private static SignificantTermsAggregatorSupplier numericSupplier() {
        return new SignificantTermsAggregatorSupplier(){

            @Override
            public Aggregator build(String name, AggregatorFactories factories, ValuesSource valuesSource, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, String executionHint, SearchContext context, Aggregator parent, SignificanceHeuristic significanceHeuristic, SignificantTermsAggregatorFactory sigTermsFactory, Map<String, Object> metadata) throws IOException {
                if (includeExclude != null && includeExclude.isRegexBased()) {
                    throw new IllegalArgumentException("Aggregation [" + name + "] cannot support regular expression style include/exclude settings as they can only be applied to string fields. Use an array of numeric values for include/exclude clauses used to filter numeric fields");
                }
                if (((ValuesSource.Numeric)valuesSource).isFloatingPoint()) {
                    throw new UnsupportedOperationException("No support for examining floating point numerics");
                }
                IncludeExclude.LongFilter longFilter = null;
                if (includeExclude != null) {
                    longFilter = includeExclude.convertToLongFilter(format);
                }
                return new SignificantLongTermsAggregator(name, factories, (ValuesSource.Numeric)valuesSource, format, bucketCountThresholds, context, parent, significanceHeuristic, sigTermsFactory, longFilter, metadata);
            }
        };
    }

    SignificantTermsAggregatorFactory(String name, ValuesSourceConfig config, IncludeExclude includeExclude, String executionHint, QueryBuilder filterBuilder, TermsAggregator.BucketCountThresholds bucketCountThresholds, SignificanceHeuristic significanceHeuristic, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        if (!config.unmapped() && !config.fieldContext().fieldType().isSearchable()) {
            throw new IllegalArgumentException("SignificantText aggregation requires fields to be searchable, but [" + config.fieldContext().fieldType().name() + "] is not");
        }
        if (!config.unmapped()) {
            this.fieldType = config.fieldContext().fieldType();
            this.indexedFieldName = this.fieldType.name();
        }
        this.includeExclude = includeExclude;
        this.executionHint = executionHint;
        this.filter = filterBuilder == null ? null : filterBuilder.toQuery(queryShardContext);
        IndexSearcher searcher = queryShardContext.searcher();
        this.supersetNumDocs = this.filter == null ? searcher.getIndexReader().maxDoc() : searcher.count(this.filter);
        this.bucketCountThresholds = bucketCountThresholds;
        this.significanceHeuristic = significanceHeuristic;
    }

    long getSupersetNumDocs() {
        return this.supersetNumDocs;
    }

    private FilterableTermsEnum getTermsEnum(String field) throws IOException {
        if (this.termsEnum != null) {
            return this.termsEnum;
        }
        IndexReader reader = this.queryShardContext.getIndexReader();
        this.termsEnum = this.numberOfAggregatorsCreated > 1 ? new FreqTermsEnum(reader, field, true, false, this.filter, this.queryShardContext.bigArrays()) : new FilterableTermsEnum(reader, this.indexedFieldName, 0, this.filter);
        return this.termsEnum;
    }

    private long getBackgroundFrequency(String value) throws IOException {
        Query query = this.fieldType.termQuery(value, this.queryShardContext);
        if (query instanceof TermQuery) {
            Term term = ((TermQuery)query).getTerm();
            FilterableTermsEnum termsEnum = this.getTermsEnum(term.field());
            if (termsEnum.seekExact(term.bytes())) {
                return termsEnum.docFreq();
            }
            return 0L;
        }
        if (this.filter != null) {
            query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.FILTER).add(this.filter, BooleanClause.Occur.FILTER).build();
        }
        return this.queryShardContext.searcher().count(query);
    }

    long getBackgroundFrequency(BytesRef termBytes) throws IOException {
        String value = this.config.format().format(termBytes).toString();
        return this.getBackgroundFrequency(value);
    }

    long getBackgroundFrequency(long termNum) throws IOException {
        String value = this.config.format().format(termNum).toString();
        return this.getBackgroundFrequency(value);
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        final UnmappedSignificantTerms aggregation = new UnmappedSignificantTerms(this.name, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), metadata);
        return new NonCollectingAggregator(this.name, searchContext, parent, metadata){

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return aggregation;
            }
        };
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource valuesSource, SearchContext searchContext, Aggregator parent, boolean collectsFromSingleBucket, Map<String, Object> metadata) throws IOException {
        if (!collectsFromSingleBucket) {
            return SignificantTermsAggregatorFactory.asMultiBucketAggregator(this, searchContext, parent);
        }
        AggregatorSupplier aggregatorSupplier = this.queryShardContext.getValuesSourceRegistry().getAggregator(this.config.valueSourceType(), "significant_terms");
        if (!(aggregatorSupplier instanceof SignificantTermsAggregatorSupplier)) {
            throw new AggregationExecutionException("Registry miss-match - expected SignificantTermsAggregatorSupplier, found [" + aggregatorSupplier.getClass().toString() + "]");
        }
        ++this.numberOfAggregatorsCreated;
        TermsAggregator.BucketCountThresholds bucketCountThresholds = new TermsAggregator.BucketCountThresholds(this.bucketCountThresholds);
        if (bucketCountThresholds.getShardSize() == SignificantTermsAggregationBuilder.DEFAULT_BUCKET_COUNT_THRESHOLDS.getShardSize()) {
            bucketCountThresholds.setShardSize(2 * BucketUtils.suggestShardSideQueueSize(bucketCountThresholds.getRequiredSize()));
        }
        SignificantTermsAggregatorSupplier sigTermsAggregatorSupplier = (SignificantTermsAggregatorSupplier)aggregatorSupplier;
        return sigTermsAggregatorSupplier.build(this.name, this.factories, valuesSource, this.config.format(), bucketCountThresholds, this.includeExclude, this.executionHint, searchContext, parent, this.significanceHeuristic, this, metadata);
    }

    @Override
    public void close() {
        try {
            if (this.termsEnum instanceof Releasable) {
                ((Releasable)((Object)this.termsEnum)).close();
            }
        }
        finally {
            this.termsEnum = null;
        }
    }

    public static enum ExecutionMode {
        MAP(new ParseField("map", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, SearchContext aggregationContext, Aggregator parent, SignificanceHeuristic significanceHeuristic, SignificantTermsAggregatorFactory termsAggregatorFactory, Map<String, Object> metadata) throws IOException {
                IncludeExclude.StringFilter filter = includeExclude == null ? null : includeExclude.convertToStringFilter(format);
                return new SignificantStringTermsAggregator(name, factories, valuesSource, format, bucketCountThresholds, filter, aggregationContext, parent, significanceHeuristic, termsAggregatorFactory, metadata);
            }
        }
        ,
        GLOBAL_ORDINALS(new ParseField("global_ordinals", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, SearchContext aggregationContext, Aggregator parent, SignificanceHeuristic significanceHeuristic, SignificantTermsAggregatorFactory termsAggregatorFactory, Map<String, Object> metadata) throws IOException {
                IncludeExclude.OrdinalsFilter filter = includeExclude == null ? null : includeExclude.convertToOrdinalsFilter(format);
                boolean remapGlobalOrd = true;
                if (!Aggregator.descendsFromBucketAggregator(parent) && factories == AggregatorFactories.EMPTY && includeExclude == null) {
                    remapGlobalOrd = false;
                }
                return new GlobalOrdinalsSignificantTermsAggregator(name, factories, (ValuesSource.Bytes.WithOrdinals.FieldData)valuesSource, format, bucketCountThresholds, filter, aggregationContext, parent, remapGlobalOrd, significanceHeuristic, termsAggregatorFactory, metadata);
            }
        };

        private final ParseField parseField;

        public static ExecutionMode fromString(String value, DeprecationLogger deprecationLogger) {
            if ("global_ordinals".equals(value)) {
                return GLOBAL_ORDINALS;
            }
            if ("global_ordinals_hash".equals(value)) {
                deprecationLogger.deprecatedAndMaybeLog("global_ordinals_hash", "global_ordinals_hash is deprecated. Please use [global_ordinals] instead.", new Object[0]);
                return GLOBAL_ORDINALS;
            }
            if ("map".equals(value)) {
                return MAP;
            }
            throw new IllegalArgumentException("Unknown `execution_hint`: [" + value + "], expected any of [map, global_ordinals]");
        }

        private ExecutionMode(ParseField parseField) {
            this.parseField = parseField;
        }

        abstract Aggregator create(String var1, AggregatorFactories var2, ValuesSource var3, DocValueFormat var4, TermsAggregator.BucketCountThresholds var5, IncludeExclude var6, SearchContext var7, Aggregator var8, SignificanceHeuristic var9, SignificantTermsAggregatorFactory var10, Map<String, Object> var11) throws IOException;

        public String toString() {
            return this.parseField.getPreferredName();
        }
    }
}

