/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.function.LongUnaryOperator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.DocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.SortedDocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.SortedSetDocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.ArrayUtil;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.LongBitSet;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lease.Releasables;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.IntArray;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.LongHash;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.AbstractSortedSetDocValues;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.DocValueFormat;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.BucketOrder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.InternalAggregations;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms.AbstractStringTermsAggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms.BucketPriorityQueue;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.internal.SearchContext;

public class GlobalOrdinalsStringTermsAggregator
extends AbstractStringTermsAggregator {
    protected final ValuesSource.Bytes.WithOrdinals valuesSource;
    protected final IncludeExclude.OrdinalsFilter includeExclude;
    protected final LongBitSet acceptedGlobalOrdinals;
    protected final long valueCount;
    protected final GlobalOrdLookupFunction lookupGlobalOrd;
    protected final LongHash bucketOrds;

    public GlobalOrdinalsStringTermsAggregator(String name, AggregatorFactories factories, ValuesSource.Bytes.WithOrdinals valuesSource, BucketOrder order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude.OrdinalsFilter includeExclude, SearchContext context, Aggregator parent, boolean remapGlobalOrds, Aggregator.SubAggCollectionMode collectionMode, boolean showTermDocCountError, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, order, format, bucketCountThresholds, collectionMode, showTermDocCountError, metadata);
        this.valuesSource = valuesSource;
        this.includeExclude = includeExclude;
        IndexReader reader = context.searcher().getIndexReader();
        SortedSetDocValues values = reader.leaves().size() > 0 ? valuesSource.globalOrdinalsValues(context.searcher().getIndexReader().leaves().get(0)) : DocValues.emptySortedSet();
        this.valueCount = values.getValueCount();
        this.lookupGlobalOrd = values::lookupOrd;
        this.acceptedGlobalOrdinals = includeExclude != null ? includeExclude.acceptedGlobalOrdinals(values) : null;
        this.bucketOrds = remapGlobalOrds ? new LongHash(1L, context.bigArrays()) : null;
    }

    boolean remapGlobalOrds() {
        return this.bucketOrds != null;
    }

    private void collectGlobalOrd(int doc, long globalOrd, LeafBucketCollector sub) throws IOException {
        if (this.bucketOrds == null) {
            this.collectExistingBucket(sub, doc, globalOrd);
        } else {
            long bucketOrd = this.bucketOrds.add(globalOrd);
            if (bucketOrd < 0L) {
                bucketOrd = -1L - bucketOrd;
                this.collectExistingBucket(sub, doc, bucketOrd);
            } else {
                this.collectBucket(sub, doc, bucketOrd);
            }
        }
    }

    private SortedSetDocValues getGlobalOrds(LeafReaderContext ctx) throws IOException {
        return this.acceptedGlobalOrdinals == null ? this.valuesSource.globalOrdinalsValues(ctx) : new FilteredOrdinals(this.valuesSource.globalOrdinalsValues(ctx), this.acceptedGlobalOrdinals);
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        SortedDocValues singleValues;
        final SortedSetDocValues globalOrds = this.getGlobalOrds(ctx);
        if (this.bucketOrds == null) {
            this.grow(globalOrds.getValueCount());
        }
        if ((singleValues = DocValues.unwrapSingleton(globalOrds)) != null) {
            return new LeafBucketCollectorBase(sub, globalOrds){

                @Override
                public void collect(int doc, long bucket) throws IOException {
                    assert (bucket == 0L);
                    if (singleValues.advanceExact(doc)) {
                        int ord = singleValues.ordValue();
                        GlobalOrdinalsStringTermsAggregator.this.collectGlobalOrd(doc, ord, sub);
                    }
                }
            };
        }
        return new LeafBucketCollectorBase(sub, globalOrds){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                assert (bucket == 0L);
                if (globalOrds.advanceExact(doc)) {
                    long globalOrd = globalOrds.nextOrd();
                    while (globalOrd != -1L) {
                        GlobalOrdinalsStringTermsAggregator.this.collectGlobalOrd(doc, globalOrd, sub);
                        globalOrd = globalOrds.nextOrd();
                    }
                }
            }
        };
    }

    protected static void copy(BytesRef from, BytesRef to) {
        if (to.bytes.length < from.length) {
            to.bytes = new byte[ArrayUtil.oversize(from.length, 1)];
        }
        to.offset = 0;
        to.length = from.length;
        System.arraycopy(from.bytes, from.offset, to.bytes, 0, from.length);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        InternalTerms.Bucket bucket;
        int i;
        if (this.valueCount == 0L) {
            return this.buildEmptyAggregation();
        }
        int size = this.bucketCountThresholds.getMinDocCount() == 0L ? (int)Math.min(this.valueCount, (long)this.bucketCountThresholds.getShardSize()) : (int)Math.min(this.maxBucketOrd(), (long)this.bucketCountThresholds.getShardSize());
        long otherDocCount = 0L;
        BucketPriorityQueue ordered = new BucketPriorityQueue(size, this.partiallyBuiltBucketComparator);
        OrdBucket spare = new OrdBucket(-1L, 0L, null, this.showTermDocCountError, 0L);
        boolean needsFullScan = this.bucketOrds == null || this.bucketCountThresholds.getMinDocCount() == 0L;
        long maxId = needsFullScan ? this.valueCount : this.bucketOrds.size();
        for (long ord = 0L; ord < maxId; ++ord) {
            int bucketDocCount;
            long globalOrd;
            long bucketOrd;
            if (needsFullScan) {
                bucketOrd = this.bucketOrds == null ? ord : this.bucketOrds.find(ord);
                globalOrd = ord;
            } else {
                assert (this.bucketOrds != null);
                bucketOrd = ord;
                globalOrd = this.bucketOrds.get(ord);
            }
            if (this.includeExclude != null && !this.acceptedGlobalOrdinals.get(globalOrd)) continue;
            int n = bucketDocCount = bucketOrd < 0L ? 0 : this.bucketDocCount(bucketOrd);
            if (this.bucketCountThresholds.getMinDocCount() > 0L && bucketDocCount == 0) continue;
            otherDocCount += (long)bucketDocCount;
            spare.globalOrd = globalOrd;
            spare.bucketOrd = bucketOrd;
            spare.docCount = bucketDocCount;
            if (this.bucketCountThresholds.getShardMinDocCount() > spare.docCount || (spare = ordered.insertWithOverflow(spare)) != null) continue;
            this.consumeBucketsAndMaybeBreak(1);
            spare = new OrdBucket(-1L, 0L, null, this.showTermDocCountError, 0L);
        }
        StringTerms.Bucket[] list = new StringTerms.Bucket[ordered.size()];
        long[] survivingBucketOrds = new long[ordered.size()];
        for (i = ordered.size() - 1; i >= 0; --i) {
            bucket = (OrdBucket)ordered.pop();
            survivingBucketOrds[i] = bucket.bucketOrd;
            BytesRef scratch = new BytesRef();
            GlobalOrdinalsStringTermsAggregator.copy(this.lookupGlobalOrd.apply(bucket.globalOrd), scratch);
            list[i] = new StringTerms.Bucket(scratch, bucket.docCount, null, this.showTermDocCountError, 0L, this.format);
            list[i].bucketOrd = bucket.bucketOrd;
            otherDocCount -= list[i].docCount;
        }
        this.runDeferredCollections(survivingBucketOrds);
        for (i = 0; i < list.length; ++i) {
            bucket = list[i];
            ((StringTerms.Bucket)bucket).aggregations = ((StringTerms.Bucket)bucket).docCount == 0L ? this.bucketEmptyAggregations() : this.bucketAggregations(((StringTerms.Bucket)bucket).bucketOrd);
            ((StringTerms.Bucket)bucket).docCountError = 0L;
        }
        return new StringTerms(this.name, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.metadata(), this.format, this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, otherDocCount, Arrays.asList(list), 0L);
    }

    @Override
    protected void doClose() {
        Releasables.close(this.bucketOrds);
    }

    public static interface GlobalOrdLookupFunction {
        public BytesRef apply(long var1) throws IOException;
    }

    private static final class FilteredOrdinals
    extends AbstractSortedSetDocValues {
        private final SortedSetDocValues inner;
        private final LongBitSet accepted;

        private FilteredOrdinals(SortedSetDocValues inner, LongBitSet accepted) {
            this.inner = inner;
            this.accepted = accepted;
        }

        @Override
        public long getValueCount() {
            return this.inner.getValueCount();
        }

        @Override
        public BytesRef lookupOrd(long ord) throws IOException {
            return this.inner.lookupOrd(ord);
        }

        @Override
        public long nextOrd() throws IOException {
            long ord = this.inner.nextOrd();
            while (ord != -1L) {
                if (this.accepted.get(ord)) {
                    return ord;
                }
                ord = this.inner.nextOrd();
            }
            return -1L;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            if (this.inner.advanceExact(target)) {
                long ord = this.inner.nextOrd();
                while (ord != -1L) {
                    if (this.accepted.get(ord)) {
                        boolean advanced = this.inner.advanceExact(target);
                        assert (advanced);
                        return true;
                    }
                    ord = this.inner.nextOrd();
                }
            }
            return false;
        }
    }

    static class OrdBucket
    extends InternalTerms.Bucket<OrdBucket> {
        long globalOrd;

        OrdBucket(long globalOrd, long docCount, InternalAggregations aggregations, boolean showDocCountError, long docCountError) {
            super(docCount, aggregations, showDocCountError, docCountError, null);
            this.globalOrd = globalOrd;
        }

        @Override
        public int compareKey(OrdBucket other) {
            return Long.compare(this.globalOrd, other.globalOrd);
        }

        @Override
        public String getKeyAsString() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Number getKeyAsNumber() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void writeTermTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected final XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    static class LowCardinality
    extends GlobalOrdinalsStringTermsAggregator {
        private LongUnaryOperator mapping;
        private IntArray segmentDocCounts;

        LowCardinality(String name, AggregatorFactories factories, ValuesSource.Bytes.WithOrdinals valuesSource, BucketOrder order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, SearchContext context, Aggregator parent, boolean forceDenseMode, Aggregator.SubAggCollectionMode collectionMode, boolean showTermDocCountError, Map<String, Object> metadata) throws IOException {
            super(name, factories, valuesSource, order, format, bucketCountThresholds, null, context, parent, forceDenseMode, collectionMode, showTermDocCountError, metadata);
            assert (factories == null || factories.countAggregators() == 0);
            this.segmentDocCounts = context.bigArrays().newIntArray(1L, true);
        }

        @Override
        public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
            if (this.mapping != null) {
                this.mapSegmentCountsToGlobalCounts(this.mapping);
            }
            final SortedSetDocValues segmentOrds = this.valuesSource.ordinalsValues(ctx);
            this.segmentDocCounts = this.context.bigArrays().grow(this.segmentDocCounts, 1L + segmentOrds.getValueCount());
            assert (sub == LeafBucketCollector.NO_OP_COLLECTOR);
            final SortedDocValues singleValues = DocValues.unwrapSingleton(segmentOrds);
            this.mapping = this.valuesSource.globalOrdinalsMapping(ctx);
            if (singleValues != null) {
                return new LeafBucketCollectorBase(sub, segmentOrds){

                    @Override
                    public void collect(int doc, long bucket) throws IOException {
                        assert (bucket == 0L);
                        if (singleValues.advanceExact(doc)) {
                            int ord = singleValues.ordValue();
                            segmentDocCounts.increment(ord + 1, 1);
                        }
                    }
                };
            }
            return new LeafBucketCollectorBase(sub, segmentOrds){

                @Override
                public void collect(int doc, long bucket) throws IOException {
                    assert (bucket == 0L);
                    if (segmentOrds.advanceExact(doc)) {
                        long segmentOrd = segmentOrds.nextOrd();
                        while (segmentOrd != -1L) {
                            segmentDocCounts.increment(segmentOrd + 1L, 1);
                            segmentOrd = segmentOrds.nextOrd();
                        }
                    }
                }
            };
        }

        @Override
        protected void doPostCollection() throws IOException {
            if (this.mapping != null) {
                this.mapSegmentCountsToGlobalCounts(this.mapping);
                this.mapping = null;
            }
        }

        @Override
        protected void doClose() {
            Releasables.close(this.segmentDocCounts);
        }

        private void mapSegmentCountsToGlobalCounts(LongUnaryOperator mapping) throws IOException {
            for (long i = 1L; i < this.segmentDocCounts.size(); ++i) {
                int inc = this.segmentDocCounts.set(i, 0);
                if (inc == 0) continue;
                long ord = i - 1L;
                long globalOrd = mapping.applyAsLong(ord);
                long bucketOrd = this.bucketOrds == null ? globalOrd : this.bucketOrds.find(globalOrd);
                this.incrementBucketDocCount(bucketOrd, inc);
            }
        }
    }
}

