/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BytesRefBuilder;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.CollectionUtil;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lease.Releasables;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.BytesRefHash;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.DocValueFormat;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms.AbstractRareTermsAggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms.LongRareTermsAggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms.StringRareTerms;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.internal.SearchContext;

public class StringRareTermsAggregator
extends AbstractRareTermsAggregator<ValuesSource.Bytes, IncludeExclude.StringFilter, BytesRef> {
    protected BytesRefHash bucketOrds;

    StringRareTermsAggregator(String name, AggregatorFactories factories, ValuesSource.Bytes valuesSource, DocValueFormat format, IncludeExclude.StringFilter stringFilter, SearchContext context, Aggregator parent, Map<String, Object> metadata, long maxDocCount, double precision) throws IOException {
        super(name, factories, context, parent, metadata, maxDocCount, precision, format, valuesSource, stringFilter);
        this.bucketOrds = new BytesRefHash(1L, context.bigArrays());
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final SortedBinaryDocValues values = ((ValuesSource.Bytes)this.valuesSource).bytesValues(ctx);
        return new LeafBucketCollectorBase(sub, values){
            final BytesRefBuilder previous;
            {
                super(sub2, values2);
                this.previous = new BytesRefBuilder();
            }

            @Override
            public void collect(int docId, long bucket) throws IOException {
                assert (bucket == 0L);
                if (values.advanceExact(docId)) {
                    int valuesCount = values.docValueCount();
                    this.previous.clear();
                    for (int i = 0; i < valuesCount; ++i) {
                        BytesRef bytes = values.nextValue();
                        if (StringRareTermsAggregator.this.includeExclude != null && !((IncludeExclude.StringFilter)StringRareTermsAggregator.this.includeExclude).accept(bytes) || i > 0 && this.previous.get().equals(bytes)) continue;
                        StringRareTermsAggregator.this.doCollect(sub, bytes, docId);
                        this.previous.copyBytes(bytes);
                    }
                }
            }
        };
    }

    @Override
    long addValueToOrds(BytesRef value) {
        return this.bucketOrds.add(value);
    }

    private List<StringRareTerms.Bucket> buildSketch() {
        long deletionCount = 0L;
        BytesRefHash newBucketOrds = new BytesRefHash(1L, this.context.bigArrays());
        ArrayList<StringRareTerms.Bucket> buckets = new ArrayList<StringRareTerms.Bucket>();
        try (BytesRefHash oldBucketOrds = this.bucketOrds;){
            long[] mergeMap = new long[(int)oldBucketOrds.size()];
            BytesRef scratch = new BytesRef();
            int i = 0;
            while ((long)i < oldBucketOrds.size()) {
                BytesRef oldKey = oldBucketOrds.get(i, scratch);
                long newBucketOrd = -1L;
                long docCount = this.bucketDocCount(i);
                if (docCount <= this.maxDocCount) {
                    newBucketOrd = newBucketOrds.add(oldKey);
                    StringRareTerms.Bucket bucket = new StringRareTerms.Bucket(BytesRef.deepCopyOf(oldKey), docCount, null, this.format);
                    bucket.bucketOrd = newBucketOrd;
                    buckets.add(bucket);
                    this.consumeBucketsAndMaybeBreak(1);
                } else {
                    ++deletionCount;
                    this.filter.add(oldKey);
                }
                mergeMap[i] = newBucketOrd;
                ++i;
            }
            if (deletionCount > 0L) {
                this.mergeBuckets(mergeMap, newBucketOrds.size());
                if (this.deferringCollector != null) {
                    this.deferringCollector.mergeBuckets(mergeMap);
                }
            }
        }
        this.bucketOrds = newBucketOrds;
        return buckets;
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        assert (owningBucketOrdinal == 0L);
        List<StringRareTerms.Bucket> buckets = this.buildSketch();
        this.runDeferredCollections(buckets.stream().mapToLong(b -> b.bucketOrd).toArray());
        for (StringRareTerms.Bucket bucket : buckets) {
            bucket.aggregations = this.bucketAggregations(bucket.bucketOrd);
        }
        CollectionUtil.introSort(buckets, ORDER.comparator());
        return new StringRareTerms(this.name, ORDER, this.metadata(), this.format, buckets, this.maxDocCount, this.filter);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new StringRareTerms(this.name, LongRareTermsAggregator.ORDER, this.metadata(), this.format, Collections.emptyList(), 0L, this.filter);
    }

    @Override
    public void doClose() {
        Releasables.close(this.bucketOrds);
    }
}

