/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryShardContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregatorFactory;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.GeoCentroidAggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.GeoCentroidAggregatorSupplier;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.AggregatorSupplier;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.internal.SearchContext;

class GeoCentroidAggregatorFactory
extends ValuesSourceAggregatorFactory {
    GeoCentroidAggregatorFactory(String name, ValuesSourceConfig config, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new GeoCentroidAggregator(this.name, searchContext, parent, null, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource valuesSource, SearchContext searchContext, Aggregator parent, boolean collectsFromSingleBucket, Map<String, Object> metadata) throws IOException {
        AggregatorSupplier aggregatorSupplier = this.queryShardContext.getValuesSourceRegistry().getAggregator(this.config.valueSourceType(), "geo_centroid");
        if (!(aggregatorSupplier instanceof GeoCentroidAggregatorSupplier)) {
            throw new AggregationExecutionException("Registry miss-match - expected " + GeoCentroidAggregatorSupplier.class.getName() + ", found [" + aggregatorSupplier.getClass().toString() + "]");
        }
        return ((GeoCentroidAggregatorSupplier)aggregatorSupplier).build(this.name, searchContext, parent, valuesSource, metadata);
    }

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register("geo_centroid", CoreValuesSourceType.GEOPOINT, (name, context, parent, valuesSource, metadata) -> new GeoCentroidAggregator(name, context, parent, (ValuesSource.GeoPoint)valuesSource, (Map<String, Object>)metadata));
    }
}

