/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.DocValueFormat;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.AbstractInternalTDigestPercentiles;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.Percentile;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.PercentileRanks;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.TDigestState;

public class InternalTDigestPercentileRanks
extends AbstractInternalTDigestPercentiles
implements PercentileRanks {
    public static final String NAME = "tdigest_percentile_ranks";

    public InternalTDigestPercentileRanks(String name, double[] cdfValues, TDigestState state, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, cdfValues, state, keyed, formatter, metadata);
    }

    public InternalTDigestPercentileRanks(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public Iterator<Percentile> iterator() {
        return new Iter(this.keys, this.state);
    }

    @Override
    public double percent(double value) {
        return InternalTDigestPercentileRanks.percentileRank(this.state, value);
    }

    @Override
    public String percentAsString(double value) {
        return this.valueAsString(String.valueOf(value));
    }

    @Override
    public double value(double key) {
        return this.percent(key);
    }

    @Override
    protected AbstractInternalTDigestPercentiles createReduced(String name, double[] keys, TDigestState merged, boolean keyed, Map<String, Object> metadata) {
        return new InternalTDigestPercentileRanks(name, keys, merged, keyed, this.format, metadata);
    }

    public static double percentileRank(TDigestState state, double value) {
        double percentileRank = state.cdf(value);
        if (percentileRank < 0.0) {
            percentileRank = 0.0;
        } else if (percentileRank > 1.0) {
            percentileRank = 1.0;
        }
        return percentileRank * 100.0;
    }

    public static class Iter
    implements Iterator<Percentile> {
        private final double[] values;
        private final TDigestState state;
        private int i;

        public Iter(double[] values, TDigestState state) {
            this.values = values;
            this.state = state;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.values.length;
        }

        @Override
        public Percentile next() {
            Percentile next = new Percentile(InternalTDigestPercentileRanks.percentileRank(this.state, this.values[this.i]), this.values[this.i]);
            ++this.i;
            return next;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

