/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryShardContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.DocValueFormat;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregatorFactory;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.MedianAbsoluteDeviationAggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.MedianAbsoluteDeviationAggregatorSupplier;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.AggregatorSupplier;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.internal.SearchContext;

public class MedianAbsoluteDeviationAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final double compression;

    MedianAbsoluteDeviationAggregatorFactory(String name, ValuesSourceConfig config, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata, double compression) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.compression = compression;
    }

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register("median_absolute_deviation", CoreValuesSourceType.NUMERIC, (AggregatorSupplier)new MedianAbsoluteDeviationAggregatorSupplier(){

            @Override
            public Aggregator build(String name, ValuesSource valuesSource, DocValueFormat format, SearchContext context, Aggregator parent, Map<String, Object> metadata, double compression) throws IOException {
                return new MedianAbsoluteDeviationAggregator(name, context, parent, metadata, (ValuesSource.Numeric)valuesSource, format, compression);
            }
        });
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new MedianAbsoluteDeviationAggregator(this.name, searchContext, parent, metadata, null, this.config.format(), this.compression);
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource valuesSource, SearchContext searchContext, Aggregator parent, boolean collectsFromSingleBucket, Map<String, Object> metadata) throws IOException {
        AggregatorSupplier aggregatorSupplier = this.queryShardContext.getValuesSourceRegistry().getAggregator(this.config.valueSourceType(), "median_absolute_deviation");
        if (!(aggregatorSupplier instanceof MedianAbsoluteDeviationAggregatorSupplier)) {
            throw new AggregationExecutionException("Registry miss-match - expected MedianAbsoluteDeviationAggregatorSupplier, found [" + aggregatorSupplier.getClass().toString() + "]");
        }
        return ((MedianAbsoluteDeviationAggregatorSupplier)aggregatorSupplier).build(this.name, valuesSource, this.config.format(), searchContext, parent, metadata, this.compression);
    }
}

