/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryShardContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregatorFactory;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.MinAggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.MinMaxAggregatorSupplier;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.AggregatorSupplier;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.internal.SearchContext;

class MinAggregatorFactory
extends ValuesSourceAggregatorFactory {
    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register("min", Arrays.asList(CoreValuesSourceType.NUMERIC, CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN), (AggregatorSupplier)new MinMaxAggregatorSupplier(){

            @Override
            public Aggregator build(String name, ValuesSourceConfig config, ValuesSource valuesSource, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
                return new MinAggregator(name, config, (ValuesSource.Numeric)valuesSource, context, parent, metadata);
            }
        });
    }

    MinAggregatorFactory(String name, ValuesSourceConfig config, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new MinAggregator(this.name, this.config, null, searchContext, parent, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource valuesSource, SearchContext searchContext, Aggregator parent, boolean collectsFromSingleBucket, Map<String, Object> metadata) throws IOException {
        AggregatorSupplier aggregatorSupplier = this.queryShardContext.getValuesSourceRegistry().getAggregator(this.config.valueSourceType(), "min");
        if (!(aggregatorSupplier instanceof MinMaxAggregatorSupplier)) {
            throw new AggregationExecutionException("Registry miss-match - expected MinMaxAggregatorSupplier, found [" + aggregatorSupplier.getClass().toString() + "]");
        }
        return ((MinMaxAggregatorSupplier)aggregatorSupplier).build(this.name, this.config, valuesSource, searchContext, parent, metadata);
    }
}

