/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.ParsedAggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.Percentile;

public abstract class ParsedPercentiles
extends ParsedAggregation
implements Iterable<Percentile> {
    protected final Map<Double, Double> percentiles = new LinkedHashMap<Double, Double>();
    protected final Map<Double, String> percentilesAsString = new HashMap<Double, String>();
    private boolean keyed;

    void addPercentile(Double key, Double value) {
        this.percentiles.put(key, value);
    }

    void addPercentileAsString(Double key, String valueAsString) {
        this.percentilesAsString.put(key, valueAsString);
    }

    protected Double getPercentile(double percent) {
        if (this.percentiles.isEmpty()) {
            return Double.NaN;
        }
        return this.percentiles.get(percent);
    }

    protected String getPercentileAsString(double percent) {
        String valueAsString = this.percentilesAsString.get(percent);
        if (valueAsString != null) {
            return valueAsString;
        }
        Double value = this.getPercentile(percent);
        if (value != null) {
            return Double.toString(value);
        }
        return null;
    }

    void setKeyed(boolean keyed) {
        this.keyed = keyed;
    }

    @Override
    public Iterator<Percentile> iterator() {
        return new Iterator<Percentile>(){
            final Iterator<Map.Entry<Double, Double>> iterator;
            {
                this.iterator = ParsedPercentiles.this.percentiles.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Percentile next() {
                Map.Entry<Double, Double> next = this.iterator.next();
                return new Percentile(next.getKey(), next.getValue());
            }
        };
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean valuesAsString;
        boolean bl = valuesAsString = !this.percentilesAsString.isEmpty();
        if (this.keyed) {
            builder.startObject(Aggregation.CommonFields.VALUES.getPreferredName());
            for (Map.Entry<Double, Double> percentile : this.percentiles.entrySet()) {
                Double key = percentile.getKey();
                Double value = percentile.getValue();
                builder.field(String.valueOf(key), value.isNaN() ? null : value);
                if (!valuesAsString || value.isNaN()) continue;
                builder.field(key + "_as_string", this.getPercentileAsString(key));
            }
            builder.endObject();
        } else {
            builder.startArray(Aggregation.CommonFields.VALUES.getPreferredName());
            for (Map.Entry<Double, Double> percentile : this.percentiles.entrySet()) {
                Double key = percentile.getKey();
                builder.startObject();
                builder.field(Aggregation.CommonFields.KEY.getPreferredName(), key);
                Double value = percentile.getValue();
                builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), value.isNaN() ? null : value);
                if (valuesAsString && !value.isNaN()) {
                    builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.getPercentileAsString(key));
                }
                builder.endObject();
            }
            builder.endArray();
        }
        return builder;
    }

    protected static void declarePercentilesFields(ObjectParser<? extends ParsedPercentiles, Void> objectParser) {
        ParsedAggregation.declareAggregationFields(objectParser);
        objectParser.declareField((parser, aggregation, context) -> {
            block13: {
                XContentParser.Token token;
                block12: {
                    token = parser.currentToken();
                    if (token != XContentParser.Token.START_OBJECT) break block12;
                    aggregation.setKeyed(true);
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token.isValue()) {
                            if (token == XContentParser.Token.VALUE_NUMBER) {
                                aggregation.addPercentile(Double.valueOf(parser.currentName()), parser.doubleValue());
                                continue;
                            }
                            if (token != XContentParser.Token.VALUE_STRING) continue;
                            int i = parser.currentName().indexOf("_as_string");
                            if (i > 0) {
                                double key = Double.valueOf(parser.currentName().substring(0, i));
                                aggregation.addPercentileAsString(key, parser.text());
                                continue;
                            }
                            aggregation.addPercentile(Double.valueOf(parser.currentName()), Double.valueOf(parser.text()));
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_NULL) {
                            aggregation.addPercentile(Double.valueOf(parser.currentName()), Double.NaN);
                            continue;
                        }
                        parser.skipChildren();
                    }
                    break block13;
                }
                if (token != XContentParser.Token.START_ARRAY) break block13;
                aggregation.setKeyed(false);
                String currentFieldName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    Double key = null;
                    Double value = null;
                    String valueAsString = null;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token.isValue()) {
                            if (Aggregation.CommonFields.KEY.getPreferredName().equals(currentFieldName)) {
                                key = parser.doubleValue();
                                continue;
                            }
                            if (Aggregation.CommonFields.VALUE.getPreferredName().equals(currentFieldName)) {
                                value = parser.doubleValue();
                                continue;
                            }
                            if (!Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName().equals(currentFieldName)) continue;
                            valueAsString = parser.text();
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_NULL) {
                            value = Double.NaN;
                            continue;
                        }
                        parser.skipChildren();
                    }
                    if (key == null) continue;
                    aggregation.addPercentile(key, value);
                    if (valueAsString == null) continue;
                    aggregation.addPercentileAsString(key, valueAsString);
                }
            }
        }, Aggregation.CommonFields.VALUES, ObjectParser.ValueType.OBJECT_ARRAY);
    }
}

