/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Scorable;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.CollectionUtils;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.Script;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.ScriptedMetricAggContexts;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.InternalScriptedMetric;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.internal.SearchContext;

class ScriptedMetricAggregator
extends MetricsAggregator {
    private final ScriptedMetricAggContexts.MapScript.LeafFactory mapScript;
    private final ScriptedMetricAggContexts.CombineScript combineScript;
    private final Script reduceScript;
    private Map<String, Object> aggState;

    ScriptedMetricAggregator(String name, ScriptedMetricAggContexts.MapScript.LeafFactory mapScript, ScriptedMetricAggContexts.CombineScript combineScript, Script reduceScript, Map<String, Object> aggState, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        this.aggState = aggState;
        this.mapScript = mapScript;
        this.combineScript = combineScript;
        this.reduceScript = reduceScript;
    }

    @Override
    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        final ScriptedMetricAggContexts.MapScript leafMapScript = this.mapScript.newInstance(ctx);
        return new LeafBucketCollectorBase(sub, leafMapScript){

            @Override
            public void setScorer(Scorable scorer) throws IOException {
                leafMapScript.setScorer(scorer);
            }

            @Override
            public void collect(int doc, long bucket) throws IOException {
                assert (bucket == 0L) : bucket;
                leafMapScript.setDocument(doc);
                leafMapScript.execute();
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        Object aggregation;
        if (this.combineScript != null) {
            aggregation = this.combineScript.execute();
            CollectionUtils.ensureNoSelfReferences(aggregation, "Scripted metric aggs combine script");
        } else {
            aggregation = this.aggState;
        }
        StreamOutput.checkWriteable(aggregation);
        return new InternalScriptedMetric(this.name, aggregation, this.reduceScript, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalScriptedMetric(this.name, (Object)null, this.reduceScript, this.metadata());
    }

    @Override
    protected void doPostCollection() throws IOException {
        CollectionUtils.ensureNoSelfReferences(this.aggState, "Scripted metric aggs map script");
        super.doPostCollection();
    }
}

