/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryShardContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.DocValueFormat;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregatorFactory;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.MetricAggregatorSupplier;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.SumAggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.AggregatorSupplier;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.internal.SearchContext;

class SumAggregatorFactory
extends ValuesSourceAggregatorFactory {
    SumAggregatorFactory(String name, ValuesSourceConfig config, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
    }

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register("sum", Arrays.asList(CoreValuesSourceType.NUMERIC, CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN), (AggregatorSupplier)new MetricAggregatorSupplier(){

            @Override
            public Aggregator build(String name, ValuesSource valuesSource, DocValueFormat formatter, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
                return new SumAggregator(name, (ValuesSource.Numeric)valuesSource, formatter, context, parent, metadata);
            }
        });
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new SumAggregator(this.name, null, this.config.format(), searchContext, parent, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource valuesSource, SearchContext searchContext, Aggregator parent, boolean collectsFromSingleBucket, Map<String, Object> metadata) throws IOException {
        AggregatorSupplier aggregatorSupplier = this.queryShardContext.getValuesSourceRegistry().getAggregator(this.config.valueSourceType(), "sum");
        if (!(aggregatorSupplier instanceof MetricAggregatorSupplier)) {
            throw new AggregationExecutionException("Registry miss-match - expected MetricAggregatorSupplier, found [" + aggregatorSupplier.getClass().toString() + "]");
        }
        return ((MetricAggregatorSupplier)aggregatorSupplier).build(this.name, valuesSource, this.config.format(), searchContext, parent, metadata);
    }
}

