/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support;

import java.time.ZoneId;
import java.util.function.LongSupplier;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.RangeFieldMapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryShardContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.AggregationScript;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.Script;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.DocValueFormat;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.FieldContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValueType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class ValuesSourceConfig {
    private final ValuesSourceType valuesSourceType;
    private FieldContext fieldContext;
    private AggregationScript.LeafFactory script;
    private ValueType scriptValueType;
    private boolean unmapped;
    private DocValueFormat format = DocValueFormat.RAW;
    private Object missing;
    private ZoneId timeZone;
    private LongSupplier nowSupplier;

    public static ValuesSourceConfig resolve(QueryShardContext context, ValueType userValueTypeHint, String field, Script script, Object missing, ZoneId timeZone, String format, ValuesSourceType defaultValueSourceType, String aggregationName) {
        return ValuesSourceConfig.internalResolve(context, userValueTypeHint, field, script, missing, timeZone, format, defaultValueSourceType, aggregationName, ValuesSourceConfig::getMappingFromRegistry);
    }

    public static ValuesSourceConfig resolveUnregistered(QueryShardContext context, ValueType userValueTypeHint, String field, Script script, Object missing, ZoneId timeZone, String format, ValuesSourceType defaultValueSourceType) {
        return ValuesSourceConfig.internalResolve(context, userValueTypeHint, field, script, missing, timeZone, format, defaultValueSourceType, null, ValuesSourceConfig::getLegacyMapping);
    }

    private static ValuesSourceConfig internalResolve(QueryShardContext context, ValueType userValueTypeHint, String field, Script script, Object missing, ZoneId timeZone, String format, ValuesSourceType defaultValueSourceType, String aggregationName, FieldResolver fieldResolver) {
        MappedFieldType fieldType = null;
        ValuesSourceType valuesSourceType = null;
        ValueType scriptValueType = userValueTypeHint;
        AggregationScript.LeafFactory aggregationScript = ValuesSourceConfig.createScript(script, context);
        boolean unmapped = false;
        if (userValueTypeHint != null) {
            valuesSourceType = userValueTypeHint.getValuesSourceType();
        }
        if (field == null) {
            if (script == null) {
                throw new IllegalStateException("value source config is invalid; must have either a field or a script");
            }
        } else {
            fieldType = context.fieldMapper(field);
            if (fieldType == null) {
                unmapped = true;
                aggregationScript = null;
            } else if (valuesSourceType == null) {
                valuesSourceType = fieldResolver.getValuesSourceType(context, fieldType, aggregationName, userValueTypeHint, defaultValueSourceType);
            }
        }
        if (valuesSourceType == null) {
            valuesSourceType = defaultValueSourceType;
        }
        ValuesSourceConfig config = new ValuesSourceConfig(valuesSourceType, fieldType, unmapped, aggregationScript, scriptValueType, context);
        config.format(ValuesSourceConfig.resolveFormat(format, valuesSourceType, timeZone, fieldType));
        config.missing(missing);
        config.timezone(timeZone);
        return config;
    }

    private static ValuesSourceType getMappingFromRegistry(QueryShardContext context, MappedFieldType fieldType, String aggregationName, ValueType userValueTypeHint, ValuesSourceType defaultValuesSourceType) {
        Object indexFieldData = context.getForField(fieldType);
        return context.getValuesSourceRegistry().getValuesSourceType(fieldType, aggregationName, (IndexFieldData<?>)indexFieldData, userValueTypeHint, defaultValuesSourceType);
    }

    private static ValuesSourceType getLegacyMapping(QueryShardContext context, MappedFieldType fieldType, String aggregationName, ValueType userValueTypeHint, ValuesSourceType defaultValuesSourceType) {
        Object indexFieldData = context.getForField(fieldType);
        if (indexFieldData instanceof IndexNumericFieldData) {
            return CoreValuesSourceType.NUMERIC;
        }
        if (indexFieldData instanceof IndexGeoPointFieldData) {
            return CoreValuesSourceType.GEOPOINT;
        }
        if (fieldType instanceof RangeFieldMapper.RangeFieldType) {
            return CoreValuesSourceType.RANGE;
        }
        if (userValueTypeHint == null) {
            return defaultValuesSourceType;
        }
        return userValueTypeHint.getValuesSourceType();
    }

    private static AggregationScript.LeafFactory createScript(Script script, QueryShardContext context) {
        if (script == null) {
            return null;
        }
        AggregationScript.Factory factory = context.compile(script, AggregationScript.CONTEXT);
        return factory.newFactory(script.getParams(), context.lookup());
    }

    private static DocValueFormat resolveFormat(@Nullable String format, @Nullable ValuesSourceType valuesSourceType, @Nullable ZoneId tz, MappedFieldType fieldType) {
        if (fieldType != null) {
            return fieldType.docValueFormat(format, tz);
        }
        return valuesSourceType.getFormatter(format, tz);
    }

    public static ValuesSourceConfig resolveFieldOnly(MappedFieldType fieldType, QueryShardContext queryShardContext) {
        return new ValuesSourceConfig(fieldType.getValuesSourceType(), fieldType, false, null, null, queryShardContext);
    }

    public static ValuesSourceConfig resolveUnmapped(ValuesSourceType valuesSourceType, QueryShardContext queryShardContext) {
        return new ValuesSourceConfig(valuesSourceType, null, true, null, null, queryShardContext);
    }

    public ValuesSourceConfig(ValuesSourceType valuesSourceType, MappedFieldType fieldType, boolean unmapped, AggregationScript.LeafFactory script, ValueType scriptValueType, QueryShardContext queryShardContext) {
        if (unmapped && fieldType != null) {
            throw new IllegalStateException("value source config is invalid; marked as unmapped but specified a mapped field");
        }
        this.valuesSourceType = valuesSourceType;
        if (fieldType != null) {
            this.fieldContext = new FieldContext(fieldType.name(), (IndexFieldData<?>)queryShardContext.getForField(fieldType), fieldType);
        }
        this.unmapped = unmapped;
        this.script = script;
        this.scriptValueType = scriptValueType;
        this.nowSupplier = queryShardContext::nowInMillis;
    }

    public ValuesSourceType valueSourceType() {
        return this.valuesSourceType;
    }

    public FieldContext fieldContext() {
        return this.fieldContext;
    }

    public AggregationScript.LeafFactory script() {
        return this.script;
    }

    public boolean unmapped() {
        return this.unmapped;
    }

    public boolean valid() {
        return this.fieldContext != null || this.script != null || this.unmapped;
    }

    public ValueType scriptValueType() {
        return this.scriptValueType;
    }

    private ValuesSourceConfig format(DocValueFormat format) {
        this.format = format;
        return this;
    }

    private ValuesSourceConfig missing(Object missing) {
        this.missing = missing;
        return this;
    }

    public Object missing() {
        return this.missing;
    }

    private ValuesSourceConfig timezone(ZoneId timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public ZoneId timezone() {
        return this.timeZone;
    }

    public DocValueFormat format() {
        return this.format;
    }

    @Nullable
    public ValuesSource toValuesSource() {
        if (!this.valid()) {
            throw new IllegalStateException("value source config is invalid; must have either a field context or a script or marked as unwrapped");
        }
        ValuesSource vs = this.unmapped() ? (this.missing() == null ? null : this.valueSourceType().getEmpty()) : (this.fieldContext() == null ? this.valueSourceType().getScript(this.script(), this.scriptValueType()) : this.valueSourceType().getField(this.fieldContext(), this.script()));
        if (this.missing() == null) {
            return vs;
        }
        return this.valueSourceType().replaceMissing(vs, this.missing, this.format, this.nowSupplier);
    }

    @FunctionalInterface
    private static interface FieldResolver {
        public ValuesSourceType getValuesSourceType(QueryShardContext var1, MappedFieldType var2, String var3, ValueType var4, ValuesSourceType var5);
    }
}

