/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.RangeFieldMapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.AggregationUsageService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.AggregatorSupplier;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValueType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class ValuesSourceRegistry {
    private final AggregationUsageService usageService;
    private final Map<String, Map<ValuesSourceType, AggregatorSupplier>> aggregatorRegistry;

    public ValuesSourceRegistry(Map<String, List<Map.Entry<ValuesSourceType, AggregatorSupplier>>> aggregatorRegistry, AggregationUsageService usageService) {
        HashMap tmp = new HashMap();
        aggregatorRegistry.forEach((key, value) -> tmp.put(key, value.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
        this.aggregatorRegistry = Collections.unmodifiableMap(tmp);
        this.usageService = usageService;
    }

    private AggregatorSupplier findMatchingSuppier(ValuesSourceType valuesSourceType, Map<ValuesSourceType, AggregatorSupplier> supportedTypes) {
        return supportedTypes.get(valuesSourceType);
    }

    public AggregatorSupplier getAggregator(ValuesSourceType valuesSourceType, String aggregationName) {
        if (aggregationName != null && this.aggregatorRegistry.containsKey(aggregationName)) {
            AggregatorSupplier supplier = this.findMatchingSuppier(valuesSourceType, this.aggregatorRegistry.get(aggregationName));
            if (supplier == null) {
                throw new AggregationExecutionException("ValuesSource type " + valuesSourceType.toString() + " is not supported for aggregation" + aggregationName);
            }
            return supplier;
        }
        throw new AggregationExecutionException("Unregistered Aggregation [" + aggregationName + "]");
    }

    public ValuesSourceType getValuesSourceType(MappedFieldType fieldType, String aggregationName, IndexFieldData<?> indexFieldData, ValueType valueType, ValuesSourceType defaultValuesSourceType) {
        if (aggregationName != null && this.aggregatorRegistry.containsKey(aggregationName)) {
            ValuesSourceType valuesSourceType = fieldType.getValuesSourceType();
            if (this.aggregatorRegistry.get(aggregationName) != null && this.findMatchingSuppier(valuesSourceType, this.aggregatorRegistry.get(aggregationName)) != null) {
                return valuesSourceType;
            }
            String fieldDescription = fieldType.typeName() + "(" + fieldType.toString() + ")";
            throw new IllegalArgumentException("Field [" + fieldType.name() + "] of type [" + fieldDescription + "] is not supported for aggregation [" + aggregationName + "]");
        }
        if (indexFieldData instanceof IndexNumericFieldData) {
            return CoreValuesSourceType.NUMERIC;
        }
        if (indexFieldData instanceof IndexGeoPointFieldData) {
            return CoreValuesSourceType.GEOPOINT;
        }
        if (fieldType instanceof RangeFieldMapper.RangeFieldType) {
            return CoreValuesSourceType.RANGE;
        }
        if (valueType == null) {
            return defaultValuesSourceType;
        }
        return valueType.getValuesSourceType();
    }

    public AggregationUsageService getUsageService() {
        return this.usageService;
    }

    public static class Builder {
        private final AggregationUsageService.Builder usageServiceBuilder;
        private final Map<String, List<Map.Entry<ValuesSourceType, AggregatorSupplier>>> aggregatorRegistry = new HashMap<String, List<Map.Entry<ValuesSourceType, AggregatorSupplier>>>();

        public Builder() {
            this.usageServiceBuilder = new AggregationUsageService.Builder();
        }

        public synchronized void register(String aggregationName, ValuesSourceType valuesSourceType, AggregatorSupplier aggregatorSupplier) {
            if (!this.aggregatorRegistry.containsKey(aggregationName)) {
                this.aggregatorRegistry.put(aggregationName, new ArrayList());
            }
            this.aggregatorRegistry.get(aggregationName).add(new AbstractMap.SimpleEntry<ValuesSourceType, AggregatorSupplier>(valuesSourceType, aggregatorSupplier));
            this.registerUsage(aggregationName, valuesSourceType);
        }

        public void register(String aggregationName, List<ValuesSourceType> valuesSourceTypes, AggregatorSupplier aggregatorSupplier) {
            for (ValuesSourceType valuesSourceType : valuesSourceTypes) {
                this.register(aggregationName, valuesSourceType, aggregatorSupplier);
            }
        }

        public void registerUsage(String aggregationName, ValuesSourceType valuesSourceType) {
            this.usageServiceBuilder.registerAggregationUsage(aggregationName, valuesSourceType.typeName());
        }

        public void registerUsage(String aggregationName) {
            this.usageServiceBuilder.registerAggregationUsage(aggregationName);
        }

        public ValuesSourceRegistry build() {
            return new ValuesSourceRegistry(this.aggregatorRegistry, this.usageServiceBuilder.build());
        }
    }
}

