/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.ReaderUtil;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.ScorerSupplier;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Weight;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Bits;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ExceptionsHelper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lucene.Lucene;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.SearchHit;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.fetch.FetchSubPhase;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.internal.SearchContext;

public final class MatchedQueriesPhase
implements FetchSubPhase {
    @Override
    public void hitsExecute(SearchContext context, SearchHit[] hits) {
        if (hits.length == 0 || context.parsedQuery() == null) {
            return;
        }
        hits = (SearchHit[])hits.clone();
        Arrays.sort(hits, (a, b) -> Integer.compare(a.docId(), b.docId()));
        List[] matchedQueries = new List[hits.length];
        for (int i = 0; i < matchedQueries.length; ++i) {
            matchedQueries[i] = new ArrayList();
        }
        HashMap<String, Query> namedQueries = new HashMap<String, Query>(context.parsedQuery().namedFilters());
        if (context.parsedPostFilter() != null) {
            namedQueries.putAll(context.parsedPostFilter().namedFilters());
        }
        try {
            for (Map.Entry entry : namedQueries.entrySet()) {
                String name = (String)entry.getKey();
                Query query = (Query)entry.getValue();
                int readerIndex = -1;
                int docBase = -1;
                Weight weight = context.searcher().createWeight(context.searcher().rewrite(query), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
                Bits matchingDocs = null;
                IndexReader indexReader = context.searcher().getIndexReader();
                for (int i = 0; i < hits.length; ++i) {
                    SearchHit hit = hits[i];
                    int hitReaderIndex = ReaderUtil.subIndex(hit.docId(), indexReader.leaves());
                    if (readerIndex != hitReaderIndex) {
                        readerIndex = hitReaderIndex;
                        LeafReaderContext ctx = indexReader.leaves().get(readerIndex);
                        docBase = ctx.docBase;
                        ScorerSupplier scorerSupplier = weight.scorerSupplier(ctx);
                        matchingDocs = Lucene.asSequentialAccessBits(ctx.reader().maxDoc(), scorerSupplier);
                    }
                    if (!matchingDocs.get(hit.docId() - docBase)) continue;
                    matchedQueries[i].add(name);
                }
            }
            for (int i = 0; i < hits.length; ++i) {
                hits[i].matchedQueries(matchedQueries[i].toArray(new String[matchedQueries[i].size()]));
            }
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
        finally {
            context.clearReleasables(SearchContext.Lifetime.COLLECTION);
        }
    }
}

