/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.lookup;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ElasticsearchParseException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.bytes.BytesReference;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.collect.Tuple;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentHelper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fieldvisitor.FieldsVisitor;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.fetch.subphase.FetchSourceContext;

public class SourceLookup
implements Map {
    private LeafReader reader;
    private int docId = -1;
    private BytesReference sourceAsBytes;
    private Map<String, Object> source;
    private XContentType sourceContentType;

    public Map<String, Object> source() {
        return this.source;
    }

    public XContentType sourceContentType() {
        return this.sourceContentType;
    }

    private Map<String, Object> loadSourceIfNeeded() {
        if (this.source != null) {
            return this.source;
        }
        if (this.sourceAsBytes != null) {
            Tuple<XContentType, Map<String, Object>> tuple = SourceLookup.sourceAsMapAndType(this.sourceAsBytes);
            this.sourceContentType = tuple.v1();
            this.source = tuple.v2();
            return this.source;
        }
        try {
            FieldsVisitor sourceFieldVisitor = new FieldsVisitor(true);
            this.reader.document(this.docId, sourceFieldVisitor);
            BytesReference source = sourceFieldVisitor.source();
            if (source == null) {
                this.source = Collections.emptyMap();
                this.sourceContentType = null;
            } else {
                Tuple<XContentType, Map<String, Object>> tuple = SourceLookup.sourceAsMapAndType(source);
                this.sourceContentType = tuple.v1();
                this.source = tuple.v2();
            }
        }
        catch (Exception e) {
            throw new ElasticsearchParseException("failed to parse / load source", (Throwable)e, new Object[0]);
        }
        return this.source;
    }

    public static Tuple<XContentType, Map<String, Object>> sourceAsMapAndType(BytesReference source) throws ElasticsearchParseException {
        return XContentHelper.convertToMap(source, false);
    }

    public static Map<String, Object> sourceAsMap(BytesReference source) throws ElasticsearchParseException {
        return SourceLookup.sourceAsMapAndType(source).v2();
    }

    public void setSegmentAndDocument(LeafReaderContext context, int docId) {
        if (this.reader == context.reader() && this.docId == docId) {
            return;
        }
        this.reader = context.reader();
        this.source = null;
        this.sourceAsBytes = null;
        this.docId = docId;
    }

    public void setSource(BytesReference source) {
        this.sourceAsBytes = source;
    }

    public void setSourceContentType(XContentType sourceContentType) {
        this.sourceContentType = sourceContentType;
    }

    public void setSource(Map<String, Object> source) {
        this.source = source;
    }

    public BytesReference internalSourceRef() {
        return this.sourceAsBytes;
    }

    public List<Object> extractRawValues(String path) {
        return XContentMapValues.extractRawValues(path, this.loadSourceIfNeeded());
    }

    public Object filter(FetchSourceContext context) {
        return context.getFilter().apply(this.loadSourceIfNeeded());
    }

    public Object get(Object key) {
        return this.loadSourceIfNeeded().get(key);
    }

    @Override
    public int size() {
        return this.loadSourceIfNeeded().size();
    }

    @Override
    public boolean isEmpty() {
        return this.loadSourceIfNeeded().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.loadSourceIfNeeded().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.loadSourceIfNeeded().containsValue(value);
    }

    public Set keySet() {
        return this.loadSourceIfNeeded().keySet();
    }

    public Collection values() {
        return this.loadSourceIfNeeded().values();
    }

    public Set entrySet() {
        return this.loadSourceIfNeeded().entrySet();
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

