/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.profile.aggregation;

import java.io.IOException;
import java.util.Iterator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.AggregationPath;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.internal.SearchContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.profile.Timer;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.profile.aggregation.AggregationProfileBreakdown;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.profile.aggregation.AggregationProfiler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.profile.aggregation.AggregationTimingType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.profile.aggregation.ProfilingLeafBucketCollector;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.sort.SortOrder;

public class ProfilingAggregator
extends Aggregator {
    private final Aggregator delegate;
    private final AggregationProfiler profiler;
    private AggregationProfileBreakdown profileBreakdown;

    public ProfilingAggregator(Aggregator delegate, AggregationProfiler profiler) throws IOException {
        this.profiler = profiler;
        this.delegate = delegate;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public ScoreMode scoreMode() {
        return this.delegate.scoreMode();
    }

    @Override
    public String name() {
        return this.delegate.name();
    }

    @Override
    public SearchContext context() {
        return this.delegate.context();
    }

    @Override
    public Aggregator parent() {
        return this.delegate.parent();
    }

    @Override
    public Aggregator subAggregator(String name) {
        return this.delegate.subAggregator(name);
    }

    @Override
    public Aggregator resolveSortPath(AggregationPath.PathElement next, Iterator<AggregationPath.PathElement> path) {
        return this.delegate.resolveSortPath(next, path);
    }

    @Override
    public Aggregator.BucketComparator bucketComparator(String key, SortOrder order) {
        return this.delegate.bucketComparator(key, order);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalAggregation buildAggregation(long bucket) throws IOException {
        InternalAggregation result;
        Timer timer = this.profileBreakdown.getTimer(AggregationTimingType.BUILD_AGGREGATION);
        timer.start();
        try {
            result = this.delegate.buildAggregation(bucket);
        }
        finally {
            timer.stop();
        }
        return result;
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return this.delegate.buildEmptyAggregation();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx) throws IOException {
        return new ProfilingLeafBucketCollector(this.delegate.getLeafCollector(ctx), this.profileBreakdown);
    }

    @Override
    public void preCollection() throws IOException {
        this.profileBreakdown = this.profiler.getQueryBreakdown(this.delegate);
        Timer timer = this.profileBreakdown.getTimer(AggregationTimingType.INITIALIZE);
        timer.start();
        try {
            this.delegate.preCollection();
        }
        finally {
            timer.stop();
        }
        this.profiler.pollLastElement();
    }

    @Override
    public void postCollection() throws IOException {
        this.delegate.postCollection();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public static Aggregator unwrap(Aggregator agg) {
        if (agg instanceof ProfilingAggregator) {
            return ((ProfilingAggregator)agg).delegate;
        }
        return agg;
    }
}

