/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.tasks;

import java.io.IOException;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.NamedWriteable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.tasks.CancellableTask;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.tasks.TaskId;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.tasks.TaskInfo;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.tasks.TaskResult;

public class Task {
    public static final String X_OPAQUE_ID = "X-Opaque-Id";
    private final long id;
    private final String type;
    private final String action;
    private final String description;
    private final TaskId parentTask;
    private final Map<String, String> headers;
    private final long startTime;
    private final long startTimeNanos;

    public Task(long id, String type, String action, String description, TaskId parentTask, Map<String, String> headers) {
        this(id, type, action, description, parentTask, System.currentTimeMillis(), System.nanoTime(), headers);
    }

    public Task(long id, String type, String action, String description, TaskId parentTask, long startTime, long startTimeNanos, Map<String, String> headers) {
        this.id = id;
        this.type = type;
        this.action = action;
        this.description = description;
        this.parentTask = parentTask;
        this.startTime = startTime;
        this.startTimeNanos = startTimeNanos;
        this.headers = headers;
    }

    public final TaskInfo taskInfo(String localNodeId, boolean detailed) {
        String description = null;
        Status status = null;
        if (detailed) {
            description = this.getDescription();
            status = this.getStatus();
        }
        return this.taskInfo(localNodeId, description, status);
    }

    protected final TaskInfo taskInfo(String localNodeId, String description, Status status) {
        return new TaskInfo(new TaskId(localNodeId, this.getId()), this.getType(), this.getAction(), description, status, this.startTime, System.nanoTime() - this.startTimeNanos, this instanceof CancellableTask, this.parentTask, this.headers);
    }

    public long getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getAction() {
        return this.action;
    }

    public String getDescription() {
        return this.description;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStartTimeNanos() {
        return this.startTimeNanos;
    }

    public TaskId getParentTaskId() {
        return this.parentTask;
    }

    public Status getStatus() {
        return null;
    }

    public String getHeader(String header) {
        return this.headers.get(header);
    }

    public TaskResult result(DiscoveryNode node, Exception error) throws IOException {
        return new TaskResult(this.taskInfo(node.getId(), true), error);
    }

    public TaskResult result(DiscoveryNode node, ActionResponse response) throws IOException {
        if (response instanceof ToXContent) {
            return new TaskResult(this.taskInfo(node.getId(), true), (ToXContent)((Object)response));
        }
        throw new IllegalStateException("response has to implement ToXContent to be able to store the results");
    }

    public static interface Status
    extends ToXContentObject,
    NamedWriteable {
    }
}

