/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.transport;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.ClusterName;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.Setting;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.transport.TransportAddress;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.concurrent.CountDown;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.ConnectTransportException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.ConnectionManager;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.RemoteConnectionInfo;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.RemoteConnectionManager;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.RemoteConnectionStrategy;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportService;

public class ProxyConnectionStrategy
extends RemoteConnectionStrategy {
    public static final Setting.AffixSetting<String> PROXY_ADDRESS = Setting.affixKeySetting("cluster.remote.", "proxy_address", (ns, key) -> Setting.simpleString(key, new RemoteConnectionStrategy.StrategyValidator<String>((String)ns, (String)key, RemoteConnectionStrategy.ConnectionStrategy.PROXY, s -> {
        if (Strings.hasLength(s)) {
            ProxyConnectionStrategy.parsePort(s);
        }
    }), Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Integer> REMOTE_SOCKET_CONNECTIONS = Setting.affixKeySetting("cluster.remote.", "proxy_socket_connections", (ns, key) -> Setting.intSetting(key, 18, 1, new RemoteConnectionStrategy.StrategyValidator<Integer>((String)ns, (String)key, RemoteConnectionStrategy.ConnectionStrategy.PROXY), Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> SERVER_NAME = Setting.affixKeySetting("cluster.remote.", "server_name", (ns, key) -> Setting.simpleString(key, new RemoteConnectionStrategy.StrategyValidator<String>((String)ns, (String)key, RemoteConnectionStrategy.ConnectionStrategy.PROXY), Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    static final int CHANNELS_PER_CONNECTION = 1;
    private static final int MAX_CONNECT_ATTEMPTS_PER_RUN = 3;
    private static final Logger logger = LogManager.getLogger(ProxyConnectionStrategy.class);
    private final int maxNumConnections;
    private final String configuredAddress;
    private final String configuredServerName;
    private final Supplier<TransportAddress> address;
    private final AtomicReference<ClusterName> remoteClusterName = new AtomicReference();
    private final ConnectionManager.ConnectionValidator clusterNameValidator;

    ProxyConnectionStrategy(String clusterAlias, TransportService transportService, RemoteConnectionManager connectionManager, Settings settings) {
        this(clusterAlias, transportService, connectionManager, settings, REMOTE_SOCKET_CONNECTIONS.getConcreteSettingForNamespace(clusterAlias).get(settings), PROXY_ADDRESS.getConcreteSettingForNamespace(clusterAlias).get(settings), SERVER_NAME.getConcreteSettingForNamespace(clusterAlias).get(settings));
    }

    ProxyConnectionStrategy(String clusterAlias, TransportService transportService, RemoteConnectionManager connectionManager, Settings settings, int maxNumConnections, String configuredAddress) {
        this(clusterAlias, transportService, connectionManager, settings, maxNumConnections, configuredAddress, () -> ProxyConnectionStrategy.resolveAddress(configuredAddress), null);
    }

    ProxyConnectionStrategy(String clusterAlias, TransportService transportService, RemoteConnectionManager connectionManager, Settings settings, int maxNumConnections, String configuredAddress, String configuredServerName) {
        this(clusterAlias, transportService, connectionManager, settings, maxNumConnections, configuredAddress, () -> ProxyConnectionStrategy.resolveAddress(configuredAddress), configuredServerName);
    }

    ProxyConnectionStrategy(String clusterAlias, TransportService transportService, RemoteConnectionManager connectionManager, Settings settings, int maxNumConnections, String configuredAddress, Supplier<TransportAddress> address, String configuredServerName) {
        super(clusterAlias, transportService, connectionManager, settings);
        this.maxNumConnections = maxNumConnections;
        this.configuredAddress = configuredAddress;
        this.configuredServerName = configuredServerName;
        assert (!Strings.isEmpty(configuredAddress)) : "Cannot use proxy connection strategy with no configured addresses";
        this.address = address;
        this.clusterNameValidator = (newConnection, actualProfile, listener) -> transportService.handshake(newConnection, actualProfile.getHandshakeTimeout().millis(), cn -> true, ActionListener.map(listener, resp -> {
            ClusterName remote = resp.getClusterName();
            if (this.remoteClusterName.compareAndSet(null, remote)) {
                return null;
            }
            if (!this.remoteClusterName.get().equals(remote)) {
                DiscoveryNode node = newConnection.getNode();
                throw new ConnectTransportException(node, "handshake failed. unexpected remote cluster name " + remote);
            }
            return null;
        }));
    }

    static Stream<Setting.AffixSetting<?>> enablementSettings() {
        return Stream.of(PROXY_ADDRESS);
    }

    static Writeable.Reader<RemoteConnectionInfo.ModeInfo> infoReader() {
        return x$0 -> new ProxyModeInfo(x$0);
    }

    @Override
    protected boolean shouldOpenMoreConnections() {
        return this.connectionManager.size() < this.maxNumConnections;
    }

    @Override
    protected boolean strategyMustBeRebuilt(Settings newSettings) {
        String address = PROXY_ADDRESS.getConcreteSettingForNamespace(this.clusterAlias).get(newSettings);
        int numOfSockets = REMOTE_SOCKET_CONNECTIONS.getConcreteSettingForNamespace(this.clusterAlias).get(newSettings);
        String serverName = SERVER_NAME.getConcreteSettingForNamespace(this.clusterAlias).get(newSettings);
        return numOfSockets != this.maxNumConnections || !this.configuredAddress.equals(address) || !Objects.equals(serverName, this.configuredServerName);
    }

    @Override
    protected RemoteConnectionStrategy.ConnectionStrategy strategyType() {
        return RemoteConnectionStrategy.ConnectionStrategy.PROXY;
    }

    @Override
    protected void connectImpl(ActionListener<Void> listener) {
        this.performProxyConnectionProcess(listener);
    }

    @Override
    public RemoteConnectionInfo.ModeInfo getModeInfo() {
        return new ProxyModeInfo(this.configuredAddress, this.configuredServerName, this.maxNumConnections, this.connectionManager.size());
    }

    private void performProxyConnectionProcess(ActionListener<Void> listener) {
        this.openConnections(listener, 1);
    }

    private void openConnections(final ActionListener<Void> finished, final int attemptNumber) {
        if (attemptNumber <= 3) {
            final TransportAddress resolved = this.address.get();
            final int remaining = this.maxNumConnections - this.connectionManager.size();
            final ActionListener<Void> compositeListener = new ActionListener<Void>(){
                private final AtomicInteger successfulConnections = new AtomicInteger(0);
                private final CountDown countDown = new CountDown(remaining);

                @Override
                public void onResponse(Void v) {
                    this.successfulConnections.incrementAndGet();
                    if (this.countDown.countDown()) {
                        if (ProxyConnectionStrategy.this.shouldOpenMoreConnections()) {
                            ProxyConnectionStrategy.this.openConnections(finished, attemptNumber + 1);
                        } else {
                            finished.onResponse(v);
                        }
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    if (this.countDown.countDown()) {
                        ProxyConnectionStrategy.this.openConnections(finished, attemptNumber + 1);
                    }
                }
            };
            for (int i = 0; i < remaining; ++i) {
                String id = this.clusterAlias + "#" + resolved;
                Map<Object, Object> attributes = Strings.isNullOrEmpty(this.configuredServerName) ? Collections.emptyMap() : Collections.singletonMap("server_name", this.configuredServerName);
                DiscoveryNode node = new DiscoveryNode(id, resolved, attributes, DiscoveryNodeRole.BUILT_IN_ROLES, Version.CURRENT.minimumCompatibilityVersion());
                this.connectionManager.connectToNode(node, null, this.clusterNameValidator, new ActionListener<Void>(){

                    @Override
                    public void onResponse(Void v) {
                        compositeListener.onResponse(v);
                    }

                    @Override
                    public void onFailure(Exception e) {
                        logger.debug((Message)new ParameterizedMessage("failed to open remote connection [remote cluster: {}, address: {}]", (Object)ProxyConnectionStrategy.this.clusterAlias, (Object)resolved), (Throwable)e);
                        compositeListener.onFailure(e);
                    }
                });
            }
        } else {
            int openConnections = this.connectionManager.size();
            if (openConnections == 0) {
                finished.onFailure(new IllegalStateException("Unable to open any proxy connections to remote cluster [" + this.clusterAlias + "]"));
            } else {
                logger.debug("unable to open maximum number of connections [remote cluster: {}, opened: {}, maximum: {}]", (Object)this.clusterAlias, (Object)openConnections, (Object)this.maxNumConnections);
                finished.onResponse(null);
            }
        }
    }

    private static TransportAddress resolveAddress(String address) {
        return new TransportAddress(ProxyConnectionStrategy.parseConfiguredAddress(address));
    }

    public static class ProxyModeInfo
    implements RemoteConnectionInfo.ModeInfo {
        private final String address;
        private final String serverName;
        private final int maxSocketConnections;
        private final int numSocketsConnected;

        public ProxyModeInfo(String address, String serverName, int maxSocketConnections, int numSocketsConnected) {
            this.address = address;
            this.serverName = serverName;
            this.maxSocketConnections = maxSocketConnections;
            this.numSocketsConnected = numSocketsConnected;
        }

        private ProxyModeInfo(StreamInput input) throws IOException {
            this.address = input.readString();
            this.serverName = input.getVersion().onOrAfter(Version.V_7_7_0) ? input.readString() : null;
            this.maxSocketConnections = input.readVInt();
            this.numSocketsConnected = input.readVInt();
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("proxy_address", this.address);
            builder.field("server_name", this.serverName);
            builder.field("num_proxy_sockets_connected", this.numSocketsConnected);
            builder.field("max_proxy_socket_connections", this.maxSocketConnections);
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.address);
            if (out.getVersion().onOrAfter(Version.V_7_7_0)) {
                out.writeString(this.serverName);
            }
            out.writeVInt(this.maxSocketConnections);
            out.writeVInt(this.numSocketsConnected);
        }

        @Override
        public boolean isConnected() {
            return this.numSocketsConnected > 0;
        }

        @Override
        public String modeName() {
            return "proxy";
        }

        public String getAddress() {
            return this.address;
        }

        public String getServerName() {
            return this.serverName;
        }

        public int getMaxSocketConnections() {
            return this.maxSocketConnections;
        }

        public int getNumSocketsConnected() {
            return this.numSocketsConnected;
        }

        @Override
        public RemoteConnectionStrategy.ConnectionStrategy modeType() {
            return RemoteConnectionStrategy.ConnectionStrategy.PROXY;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProxyModeInfo otherProxy = (ProxyModeInfo)o;
            return this.maxSocketConnections == otherProxy.maxSocketConnections && this.numSocketsConnected == otherProxy.numSocketsConnected && Objects.equals(this.address, otherProxy.address) && Objects.equals(this.serverName, otherProxy.serverName);
        }

        public int hashCode() {
            return Objects.hash(this.address, this.serverName, this.maxSocketConnections, this.numSocketsConnected);
        }
    }
}

