/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.transport;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.tasks.Task;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.tasks.TaskManager;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportChannel;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportResponse;

public class TaskTransportChannel
implements TransportChannel {
    private final Task task;
    private final TaskManager taskManager;
    private final TransportChannel channel;

    TaskTransportChannel(TaskManager taskManager, Task task, TransportChannel channel) {
        this.channel = channel;
        this.task = task;
        this.taskManager = taskManager;
    }

    @Override
    public String getProfileName() {
        return this.channel.getProfileName();
    }

    @Override
    public String getChannelType() {
        return this.channel.getChannelType();
    }

    @Override
    public void sendResponse(TransportResponse response) throws IOException {
        this.endTask();
        this.channel.sendResponse(response);
    }

    @Override
    public void sendResponse(Exception exception) throws IOException {
        this.endTask();
        this.channel.sendResponse(exception);
    }

    @Override
    public Version getVersion() {
        return this.channel.getVersion();
    }

    public TransportChannel getChannel() {
        return this.channel;
    }

    private void endTask() {
        this.taskManager.unregister(this.task);
    }
}

