/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.transport;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListenerResponseHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.PlainActionFuture;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Client;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.transport.TransportClient;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.ClusterName;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lease.Releasable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.logging.Loggers;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.regex.Regex;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.ClusterSettings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.transport.BoundTransportAddress;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.transport.TransportAddress;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.concurrent.ThreadContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.core.internal.io.IOUtils;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.node.Node;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.node.NodeClosedException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.node.ReportingService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.tasks.Task;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.tasks.TaskManager;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.threadpool.Scheduler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.threadpool.ThreadPool;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.ActionNotFoundTransportException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.ClusterConnectionManager;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.ConnectTransportException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.ConnectionManager;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.ConnectionProfile;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.NodeDisconnectedException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.NodeNotConnectedException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.PlainTransportFuture;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.ReceiveTimeoutTransportException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.RemoteClusterService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.RemoteTransportException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.RequestHandlerRegistry;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.ResponseHandlerFailureTransportException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.SendRequestTransportException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.Transport;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportChannel;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportConnectionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportFuture;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportInfo;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportInterceptor;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportMessageListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportRequestHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportRequestOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportResponseHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportSettings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportStats;

public class TransportService
extends AbstractLifecycleComponent
implements ReportingService<TransportInfo>,
TransportMessageListener,
TransportConnectionListener {
    private static final Logger logger = LogManager.getLogger(TransportService.class);
    public static final String DIRECT_RESPONSE_PROFILE = ".direct";
    public static final String HANDSHAKE_ACTION_NAME = "internal:transport/handshake";
    private final AtomicBoolean handleIncomingRequests = new AtomicBoolean();
    private final DelegatingTransportMessageListener messageListener = new DelegatingTransportMessageListener();
    protected final Transport transport;
    protected final ConnectionManager connectionManager;
    protected final ThreadPool threadPool;
    protected final ClusterName clusterName;
    protected final TaskManager taskManager;
    private final TransportInterceptor.AsyncSender asyncSender;
    private final Function<BoundTransportAddress, DiscoveryNode> localNodeFactory;
    private final boolean remoteClusterClient;
    private final Transport.ResponseHandlers responseHandlers;
    private final TransportInterceptor interceptor;
    final Map<Long, TimeoutInfoHolder> timeoutInfoHandlers = Collections.synchronizedMap(new LinkedHashMap<Long, TimeoutInfoHolder>(100, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 100;
        }
    });
    public static final TransportInterceptor NOOP_TRANSPORT_INTERCEPTOR = new TransportInterceptor(){};
    private final Logger tracerLog;
    volatile String[] tracerLogInclude;
    volatile String[] tracerLogExclude;
    private final RemoteClusterService remoteClusterService;
    private final boolean validateConnections;
    volatile DiscoveryNode localNode = null;
    private final Transport.Connection localNodeConnection = new Transport.Connection(){

        @Override
        public DiscoveryNode getNode() {
            return TransportService.this.localNode;
        }

        @Override
        public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws TransportException {
            TransportService.this.sendLocalRequest(requestId, action, request, options);
        }

        @Override
        public void addCloseListener(ActionListener<Void> listener) {
        }

        @Override
        public boolean isClosed() {
            return false;
        }

        @Override
        public void close() {
        }
    };
    public static final Set<String> VALID_ACTION_PREFIXES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("indices:admin", "indices:monitor", "indices:data/write", "indices:data/read", "indices:internal", "cluster:admin", "cluster:monitor", "cluster:internal", "internal:")));

    public TransportService(Settings settings, Transport transport, ThreadPool threadPool, TransportInterceptor transportInterceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, @Nullable ClusterSettings clusterSettings, Set<String> taskHeaders) {
        this(settings, transport, threadPool, transportInterceptor, localNodeFactory, clusterSettings, taskHeaders, new ClusterConnectionManager(settings, transport));
    }

    public TransportService(Settings settings, Transport transport, ThreadPool threadPool, TransportInterceptor transportInterceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, @Nullable ClusterSettings clusterSettings, Set<String> taskHeaders, ConnectionManager connectionManager) {
        this.validateConnections = !"transport".equals(settings.get(Client.CLIENT_TYPE_SETTING_S.getKey())) || TransportClient.CLIENT_TRANSPORT_SNIFF.get(settings) != false;
        this.transport = transport;
        this.threadPool = threadPool;
        this.localNodeFactory = localNodeFactory;
        this.connectionManager = connectionManager;
        this.clusterName = ClusterName.CLUSTER_NAME_SETTING.get(settings);
        this.setTracerLogInclude(TransportSettings.TRACE_LOG_INCLUDE_SETTING.get(settings));
        this.setTracerLogExclude(TransportSettings.TRACE_LOG_EXCLUDE_SETTING.get(settings));
        this.tracerLog = Loggers.getLogger(logger, ".tracer");
        this.taskManager = this.createTaskManager(settings, threadPool, taskHeaders);
        this.interceptor = transportInterceptor;
        this.asyncSender = this.interceptor.interceptSender(this::sendRequestInternal);
        this.remoteClusterClient = Node.NODE_REMOTE_CLUSTER_CLIENT.get(settings);
        this.remoteClusterService = new RemoteClusterService(settings, this);
        this.responseHandlers = transport.getResponseHandlers();
        if (clusterSettings != null) {
            clusterSettings.addSettingsUpdateConsumer(TransportSettings.TRACE_LOG_INCLUDE_SETTING, this::setTracerLogInclude);
            clusterSettings.addSettingsUpdateConsumer(TransportSettings.TRACE_LOG_EXCLUDE_SETTING, this::setTracerLogExclude);
            if (this.remoteClusterClient) {
                this.remoteClusterService.listenForUpdates(clusterSettings);
            }
        }
        this.registerRequestHandler(HANDSHAKE_ACTION_NAME, "same", false, false, HandshakeRequest::new, (request, channel, task) -> channel.sendResponse(new HandshakeResponse(this.localNode, this.clusterName, this.localNode.getVersion())));
    }

    public RemoteClusterService getRemoteClusterService() {
        return this.remoteClusterService;
    }

    public DiscoveryNode getLocalNode() {
        return this.localNode;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    protected TaskManager createTaskManager(Settings settings, ThreadPool threadPool, Set<String> taskHeaders) {
        return new TaskManager(settings, threadPool, taskHeaders);
    }

    private ExecutorService getExecutorService() {
        return this.threadPool.generic();
    }

    void setTracerLogInclude(List<String> tracerLogInclude) {
        this.tracerLogInclude = tracerLogInclude.toArray(Strings.EMPTY_ARRAY);
    }

    void setTracerLogExclude(List<String> tracerLogExclude) {
        this.tracerLogExclude = tracerLogExclude.toArray(Strings.EMPTY_ARRAY);
    }

    @Override
    protected void doStart() {
        this.transport.setMessageListener(this);
        this.connectionManager.addListener(this);
        this.transport.start();
        if (this.transport.boundAddress() != null && logger.isInfoEnabled()) {
            logger.info("{}", (Object)this.transport.boundAddress());
            for (Map.Entry<String, BoundTransportAddress> entry : this.transport.profileBoundAddresses().entrySet()) {
                logger.info("profile [{}]: {}", (Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        this.localNode = this.localNodeFactory.apply(this.transport.boundAddress());
        if (this.remoteClusterClient) {
            this.remoteClusterService.initializeRemoteClusters();
        }
    }

    @Override
    protected void doStop() {
        try {
            Closeable[] closeableArray = new Closeable[3];
            closeableArray[0] = this.connectionManager;
            closeableArray[1] = this.remoteClusterService;
            closeableArray[2] = this.transport::stop;
            IOUtils.close(closeableArray);
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                for (Transport.ResponseContext<? extends TransportResponse> holderToNotify : this.responseHandlers.prune(h -> true)) {
                    this.getExecutorService().execute(new AbstractRunnable(holderToNotify){
                        final /* synthetic */ Transport.ResponseContext val$holderToNotify;
                        {
                            this.val$holderToNotify = responseContext;
                        }

                        @Override
                        public void onRejection(Exception e) {
                            logger.debug(() -> new ParameterizedMessage("failed to notify response handler on rejection, action: {}", (Object)this.val$holderToNotify.action()), (Throwable)e);
                        }

                        @Override
                        public void onFailure(Exception e) {
                            logger.warn(() -> new ParameterizedMessage("failed to notify response handler on exception, action: {}", (Object)this.val$holderToNotify.action()), (Throwable)e);
                        }

                        @Override
                        public void doRun() {
                            SendRequestTransportException ex = new SendRequestTransportException(this.val$holderToNotify.connection().getNode(), this.val$holderToNotify.action(), new NodeClosedException(TransportService.this.localNode));
                            this.val$holderToNotify.handler().handleException(ex);
                        }
                    });
                }
                throw throwable;
            }
        }
        for (Transport.ResponseContext<? extends TransportResponse> holderToNotify : this.responseHandlers.prune(h -> true)) {
            this.getExecutorService().execute(new /* invalid duplicate definition of identical inner class */);
        }
    }

    @Override
    protected void doClose() throws IOException {
        this.transport.close();
    }

    public final void acceptIncomingRequests() {
        this.handleIncomingRequests.set(true);
    }

    @Override
    public TransportInfo info() {
        BoundTransportAddress boundTransportAddress = this.boundAddress();
        if (boundTransportAddress == null) {
            return null;
        }
        return new TransportInfo(boundTransportAddress, this.transport.profileBoundAddresses());
    }

    public TransportStats stats() {
        return this.transport.getStats();
    }

    public boolean isTransportSecure() {
        return this.transport.isSecure();
    }

    public BoundTransportAddress boundAddress() {
        return this.transport.boundAddress();
    }

    public List<String> getDefaultSeedAddresses() {
        return this.transport.getDefaultSeedAddresses();
    }

    public boolean nodeConnected(DiscoveryNode node) {
        return this.isLocalNode(node) || this.connectionManager.nodeConnected(node);
    }

    public void connectToNode(DiscoveryNode node) throws ConnectTransportException {
        this.connectToNode(node, (ConnectionProfile)null);
    }

    public void connectToNode(DiscoveryNode node, ConnectionProfile connectionProfile) {
        PlainActionFuture.get(fut -> this.connectToNode(node, connectionProfile, ActionListener.map(fut, x -> null)));
    }

    public void connectToNode(DiscoveryNode node, ActionListener<Void> listener) throws ConnectTransportException {
        this.connectToNode(node, null, listener);
    }

    public void connectToNode(DiscoveryNode node, ConnectionProfile connectionProfile, ActionListener<Void> listener) {
        if (this.isLocalNode(node)) {
            listener.onResponse(null);
            return;
        }
        this.connectionManager.connectToNode(node, connectionProfile, this.connectionValidator(node), listener);
    }

    public ConnectionManager.ConnectionValidator connectionValidator(DiscoveryNode node) {
        return (newConnection, actualProfile, listener) -> this.handshake(newConnection, actualProfile.getHandshakeTimeout().millis(), cn -> true, ActionListener.map(listener, resp -> {
            DiscoveryNode remote = ((HandshakeResponse)resp).discoveryNode;
            if (this.validateConnections && !node.equals(remote)) {
                throw new ConnectTransportException(node, "handshake failed. unexpected remote node " + remote);
            }
            return null;
        }));
    }

    public Transport.Connection openConnection(DiscoveryNode node, ConnectionProfile connectionProfile) {
        return (Transport.Connection)PlainActionFuture.get(fut -> this.openConnection(node, connectionProfile, (ActionListener<Transport.Connection>)fut));
    }

    public void openConnection(DiscoveryNode node, ConnectionProfile connectionProfile, ActionListener<Transport.Connection> listener) {
        if (this.isLocalNode(node)) {
            listener.onResponse(this.localNodeConnection);
        } else {
            this.connectionManager.openConnection(node, connectionProfile, listener);
        }
    }

    public void handshake(Transport.Connection connection, long handshakeTimeout, ActionListener<DiscoveryNode> listener) {
        this.handshake(connection, handshakeTimeout, this.clusterName.getEqualityPredicate(), ActionListener.map(listener, HandshakeResponse::getDiscoveryNode));
    }

    public void handshake(Transport.Connection connection, long handshakeTimeout, final Predicate<ClusterName> clusterNamePredicate, final ActionListener<HandshakeResponse> listener) {
        final DiscoveryNode node = connection.getNode();
        this.sendRequest(connection, HANDSHAKE_ACTION_NAME, (TransportRequest)HandshakeRequest.INSTANCE, TransportRequestOptions.builder().withTimeout(handshakeTimeout).build(), new ActionListenerResponseHandler<HandshakeResponse>(new ActionListener<HandshakeResponse>(){

            @Override
            public void onResponse(HandshakeResponse response) {
                if (!clusterNamePredicate.test(response.clusterName)) {
                    listener.onFailure(new IllegalStateException("handshake with [" + node + "] failed: remote cluster name [" + response.clusterName.value() + "] does not match " + clusterNamePredicate));
                } else if (!response.version.isCompatible(TransportService.this.localNode.getVersion())) {
                    listener.onFailure(new IllegalStateException("handshake with [" + node + "] failed: remote node version [" + response.version + "] is incompatible with local node version [" + TransportService.this.localNode.getVersion() + "]"));
                } else {
                    listener.onResponse(response);
                }
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        }, HandshakeResponse::new, "generic"));
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void disconnectFromNode(DiscoveryNode node) {
        if (this.isLocalNode(node)) {
            return;
        }
        this.connectionManager.disconnectFromNode(node);
    }

    public void addMessageListener(TransportMessageListener listener) {
        this.messageListener.listeners.add(listener);
    }

    public boolean removeMessageListener(TransportMessageListener listener) {
        return this.messageListener.listeners.remove(listener);
    }

    public void addConnectionListener(TransportConnectionListener listener) {
        this.connectionManager.addListener(listener);
    }

    public void removeConnectionListener(TransportConnectionListener listener) {
        this.connectionManager.removeListener(listener);
    }

    public <T extends TransportResponse> TransportFuture<T> submitRequest(DiscoveryNode node, String action, TransportRequest request, TransportResponseHandler<T> handler) throws TransportException {
        return this.submitRequest(node, action, request, TransportRequestOptions.EMPTY, handler);
    }

    public <T extends TransportResponse> TransportFuture<T> submitRequest(DiscoveryNode node, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) throws TransportException {
        PlainTransportFuture<T> futureHandler = new PlainTransportFuture<T>(handler);
        try {
            Transport.Connection connection = this.getConnection(node);
            this.sendRequest(connection, action, request, options, futureHandler);
        }
        catch (NodeNotConnectedException ex) {
            futureHandler.handleException(ex);
        }
        return futureHandler;
    }

    public <T extends TransportResponse> void sendRequest(DiscoveryNode node, String action, TransportRequest request, TransportResponseHandler<T> handler) {
        Transport.Connection connection;
        try {
            connection = this.getConnection(node);
        }
        catch (NodeNotConnectedException ex) {
            handler.handleException(ex);
            return;
        }
        this.sendRequest(connection, action, request, TransportRequestOptions.EMPTY, handler);
    }

    public final <T extends TransportResponse> void sendRequest(DiscoveryNode node, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        Transport.Connection connection;
        try {
            connection = this.getConnection(node);
        }
        catch (NodeNotConnectedException ex) {
            handler.handleException(ex);
            return;
        }
        this.sendRequest(connection, action, request, options, handler);
    }

    public final <T extends TransportResponse> void sendRequest(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        try {
            if (request.getParentTask().isSet()) {
                final Releasable unregisterChildNode = this.taskManager.registerChildNode(request.getParentTask().getId(), connection.getNode());
                final TransportResponseHandler delegate = handler;
                handler = new TransportResponseHandler<T>(){

                    @Override
                    public void handleResponse(T response) {
                        unregisterChildNode.close();
                        delegate.handleResponse(response);
                    }

                    @Override
                    public void handleException(TransportException exp) {
                        unregisterChildNode.close();
                        delegate.handleException(exp);
                    }

                    @Override
                    public String executor() {
                        return delegate.executor();
                    }

                    @Override
                    public T read(StreamInput in) throws IOException {
                        return (TransportResponse)delegate.read(in);
                    }
                };
            }
            this.asyncSender.sendRequest(connection, action, request, options, handler);
        }
        catch (Exception ex) {
            TransportException te = ex instanceof TransportException ? (TransportException)ex : new TransportException("failure to send", ex);
            handler.handleException(te);
        }
    }

    public Transport.Connection getConnection(DiscoveryNode node) {
        if (this.isLocalNode(node)) {
            return this.localNodeConnection;
        }
        return this.connectionManager.getConnection(node);
    }

    public final <T extends TransportResponse> void sendChildRequest(DiscoveryNode node, String action, TransportRequest request, Task parentTask, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        Transport.Connection connection;
        try {
            connection = this.getConnection(node);
        }
        catch (NodeNotConnectedException ex) {
            handler.handleException(ex);
            return;
        }
        this.sendChildRequest(connection, action, request, parentTask, options, handler);
    }

    public <T extends TransportResponse> void sendChildRequest(Transport.Connection connection, String action, TransportRequest request, Task parentTask, TransportResponseHandler<T> handler) {
        this.sendChildRequest(connection, action, request, parentTask, TransportRequestOptions.EMPTY, handler);
    }

    public <T extends TransportResponse> void sendChildRequest(Transport.Connection connection, String action, TransportRequest request, Task parentTask, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        request.setParentTask(this.localNode.getId(), parentTask.getId());
        this.sendRequest(connection, action, request, options, handler);
    }

    private <T extends TransportResponse> void sendRequestInternal(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        TimeoutHandler timeoutHandler;
        if (connection == null) {
            throw new IllegalStateException("can't send request to a null connection");
        }
        DiscoveryNode node = connection.getNode();
        Supplier<ThreadContext.StoredContext> storedContextSupplier = this.threadPool.getThreadContext().newRestorableContext(true);
        ContextRestoreResponseHandler<T> responseHandler = new ContextRestoreResponseHandler<T>(storedContextSupplier, handler);
        long requestId = this.responseHandlers.add(new Transport.ResponseContext<T>(responseHandler, connection, action));
        if (options.timeout() != null) {
            timeoutHandler = new TimeoutHandler(requestId, connection.getNode(), action);
            responseHandler.setTimeoutHandler(timeoutHandler);
        } else {
            timeoutHandler = null;
        }
        try {
            if (this.lifecycle.stoppedOrClosed()) {
                throw new NodeClosedException(this.localNode);
            }
            if (timeoutHandler != null) {
                assert (options.timeout() != null);
                timeoutHandler.scheduleTimeout(options.timeout());
            }
            connection.sendRequest(requestId, action, request, options);
        }
        catch (Exception e) {
            final Transport.ResponseContext<? extends TransportResponse> contextToNotify = this.responseHandlers.remove(requestId);
            if (contextToNotify != null) {
                if (timeoutHandler != null) {
                    timeoutHandler.cancel();
                }
                final SendRequestTransportException sendRequestException = new SendRequestTransportException(node, action, e);
                String executor = this.lifecycle.stoppedOrClosed() ? "same" : "generic";
                this.threadPool.executor(executor).execute(new AbstractRunnable(){

                    @Override
                    public void onRejection(Exception e) {
                        logger.debug(() -> new ParameterizedMessage("failed to notify response handler on rejection, action: {}", (Object)contextToNotify.action()), (Throwable)e);
                    }

                    @Override
                    public void onFailure(Exception e) {
                        logger.warn(() -> new ParameterizedMessage("failed to notify response handler on exception, action: {}", (Object)contextToNotify.action()), (Throwable)e);
                    }

                    @Override
                    protected void doRun() throws Exception {
                        contextToNotify.handler().handleException(sendRequestException);
                    }
                });
            }
            logger.debug("Exception while sending request, handler likely already notified due to timeout", (Throwable)e);
        }
    }

    private void sendLocalRequest(final long requestId, final String action, final TransportRequest request, TransportRequestOptions options) {
        final DirectResponseChannel channel = new DirectResponseChannel(this.localNode, action, requestId, this, this.threadPool);
        try {
            this.onRequestSent(this.localNode, requestId, action, request, options);
            this.onRequestReceived(requestId, action);
            final RequestHandlerRegistry<? extends TransportRequest> reg = this.getRequestHandler(action);
            if (reg == null) {
                throw new ActionNotFoundTransportException("Action [" + action + "] not found");
            }
            String executor = reg.getExecutor();
            if ("same".equals(executor)) {
                reg.processMessageReceived(request, channel);
            } else {
                this.threadPool.executor(executor).execute(new AbstractRunnable(){

                    @Override
                    protected void doRun() throws Exception {
                        reg.processMessageReceived(request, channel);
                    }

                    @Override
                    public boolean isForceExecution() {
                        return reg.isForceExecution();
                    }

                    @Override
                    public void onFailure(Exception e) {
                        try {
                            channel.sendResponse(e);
                        }
                        catch (Exception inner) {
                            inner.addSuppressed(e);
                            logger.warn(() -> new ParameterizedMessage("failed to notify channel of error message for action [{}]", (Object)action), (Throwable)inner);
                        }
                    }

                    public String toString() {
                        return "processing of [" + requestId + "][" + action + "]: " + request;
                    }
                });
            }
        }
        catch (Exception e) {
            try {
                channel.sendResponse(e);
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                logger.warn(() -> new ParameterizedMessage("failed to notify channel of error message for action [{}]", (Object)action), (Throwable)inner);
            }
        }
    }

    private boolean shouldTraceAction(String action) {
        return TransportService.shouldTraceAction(action, this.tracerLogInclude, this.tracerLogExclude);
    }

    public static boolean shouldTraceAction(String action, String[] include, String[] exclude) {
        if (include.length > 0 && !Regex.simpleMatch(include, action)) {
            return false;
        }
        if (exclude.length > 0) {
            return !Regex.simpleMatch(exclude, action);
        }
        return true;
    }

    public TransportAddress[] addressesFromString(String address) throws UnknownHostException {
        return this.transport.addressesFromString(address);
    }

    private void validateActionName(String actionName) {
        if (!TransportService.isValidActionName(actionName)) {
            logger.warn("invalid action name [" + actionName + "] must start with one of: " + VALID_ACTION_PREFIXES);
        }
    }

    public static boolean isValidActionName(String actionName) {
        for (String prefix : VALID_ACTION_PREFIXES) {
            if (!actionName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public <Request extends TransportRequest> void registerRequestHandler(String action, String executor, Writeable.Reader<Request> requestReader, TransportRequestHandler<Request> handler) {
        this.validateActionName(action);
        handler = this.interceptor.interceptHandler(action, executor, false, handler);
        RequestHandlerRegistry<Request> reg = new RequestHandlerRegistry<Request>(action, requestReader, this.taskManager, handler, executor, false, true);
        this.transport.registerRequestHandler(reg);
    }

    public <Request extends TransportRequest> void registerRequestHandler(String action, String executor, boolean forceExecution, boolean canTripCircuitBreaker, Writeable.Reader<Request> requestReader, TransportRequestHandler<Request> handler) {
        this.validateActionName(action);
        handler = this.interceptor.interceptHandler(action, executor, forceExecution, handler);
        RequestHandlerRegistry<Request> reg = new RequestHandlerRegistry<Request>(action, requestReader, this.taskManager, handler, executor, forceExecution, canTripCircuitBreaker);
        this.transport.registerRequestHandler(reg);
    }

    @Override
    public void onRequestReceived(long requestId, String action) {
        if (!this.handleIncomingRequests.get()) {
            throw new IllegalStateException("transport not ready yet to handle incoming requests");
        }
        if (this.tracerLog.isTraceEnabled() && this.shouldTraceAction(action)) {
            this.tracerLog.trace("[{}][{}] received request", (Object)requestId, (Object)action);
        }
        this.messageListener.onRequestReceived(requestId, action);
    }

    @Override
    public void onRequestSent(DiscoveryNode node, long requestId, String action, TransportRequest request, TransportRequestOptions options) {
        if (this.tracerLog.isTraceEnabled() && this.shouldTraceAction(action)) {
            this.tracerLog.trace("[{}][{}] sent to [{}] (timeout: [{}])", (Object)requestId, (Object)action, (Object)node, (Object)options.timeout());
        }
        this.messageListener.onRequestSent(node, requestId, action, request, options);
    }

    @Override
    public void onResponseReceived(long requestId, Transport.ResponseContext holder) {
        if (holder == null) {
            this.checkForTimeout(requestId);
        } else if (this.tracerLog.isTraceEnabled() && this.shouldTraceAction(holder.action())) {
            this.tracerLog.trace("[{}][{}] received response from [{}]", (Object)requestId, (Object)holder.action(), (Object)holder.connection().getNode());
        }
        this.messageListener.onResponseReceived(requestId, holder);
    }

    @Override
    public void onResponseSent(long requestId, String action, TransportResponse response) {
        if (this.tracerLog.isTraceEnabled() && this.shouldTraceAction(action)) {
            this.tracerLog.trace("[{}][{}] sent response", (Object)requestId, (Object)action);
        }
        this.messageListener.onResponseSent(requestId, action, response);
    }

    @Override
    public void onResponseSent(long requestId, String action, Exception e) {
        if (this.tracerLog.isTraceEnabled() && this.shouldTraceAction(action)) {
            this.tracerLog.trace(() -> new ParameterizedMessage("[{}][{}] sent error response", (Object)requestId, (Object)action), (Throwable)e);
        }
        this.messageListener.onResponseSent(requestId, action, e);
    }

    public RequestHandlerRegistry<? extends TransportRequest> getRequestHandler(String action) {
        return this.transport.getRequestHandlers().getHandler(action);
    }

    private void checkForTimeout(long requestId) {
        DiscoveryNode sourceNode;
        String action;
        assert (!this.responseHandlers.contains(requestId));
        TimeoutInfoHolder timeoutInfoHolder = this.timeoutInfoHandlers.remove(requestId);
        if (timeoutInfoHolder != null) {
            long time = this.threadPool.relativeTimeInMillis();
            logger.warn("Received response for a request that has timed out, sent [{}ms] ago, timed out [{}ms] ago, action [{}], node [{}], id [{}]", (Object)(time - timeoutInfoHolder.sentTime()), (Object)(time - timeoutInfoHolder.timeoutTime()), (Object)timeoutInfoHolder.action(), (Object)timeoutInfoHolder.node(), (Object)requestId);
            action = timeoutInfoHolder.action();
            sourceNode = timeoutInfoHolder.node();
        } else {
            logger.warn("Transport response handler not found of id [{}]", (Object)requestId);
            action = null;
            sourceNode = null;
        }
        if (!this.tracerLog.isTraceEnabled()) {
            return;
        }
        if (action == null) {
            assert (sourceNode == null);
            this.tracerLog.trace("[{}] received response but can't resolve it to a request", (Object)requestId);
        } else if (this.shouldTraceAction(action)) {
            this.tracerLog.trace("[{}][{}] received response from [{}]", (Object)requestId, (Object)action, sourceNode);
        }
    }

    @Override
    public void onConnectionClosed(final Transport.Connection connection) {
        try {
            final List<Transport.ResponseContext<? extends TransportResponse>> pruned = this.responseHandlers.prune(h -> h.connection().getCacheKey().equals(connection.getCacheKey()));
            this.getExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    for (Transport.ResponseContext holderToNotify : pruned) {
                        holderToNotify.handler().handleException(new NodeDisconnectedException(connection.getNode(), holderToNotify.action()));
                    }
                }

                public String toString() {
                    return "onConnectionClosed(" + connection.getNode() + ")";
                }
            });
        }
        catch (EsRejectedExecutionException ex) {
            logger.debug("Rejected execution on onConnectionClosed", (Throwable)ex);
        }
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    private boolean isLocalNode(DiscoveryNode discoveryNode) {
        return Objects.requireNonNull(discoveryNode, "discovery node must not be null").equals(this.localNode);
    }

    private static final class DelegatingTransportMessageListener
    implements TransportMessageListener {
        private final List<TransportMessageListener> listeners = new CopyOnWriteArrayList<TransportMessageListener>();

        private DelegatingTransportMessageListener() {
        }

        @Override
        public void onRequestReceived(long requestId, String action) {
            for (TransportMessageListener listener : this.listeners) {
                listener.onRequestReceived(requestId, action);
            }
        }

        @Override
        public void onResponseSent(long requestId, String action, TransportResponse response) {
            for (TransportMessageListener listener : this.listeners) {
                listener.onResponseSent(requestId, action, response);
            }
        }

        @Override
        public void onResponseSent(long requestId, String action, Exception error) {
            for (TransportMessageListener listener : this.listeners) {
                listener.onResponseSent(requestId, action, error);
            }
        }

        @Override
        public void onRequestSent(DiscoveryNode node, long requestId, String action, TransportRequest request, TransportRequestOptions finalOptions) {
            for (TransportMessageListener listener : this.listeners) {
                listener.onRequestSent(node, requestId, action, request, finalOptions);
            }
        }

        @Override
        public void onResponseReceived(long requestId, Transport.ResponseContext holder) {
            for (TransportMessageListener listener : this.listeners) {
                listener.onResponseReceived(requestId, holder);
            }
        }
    }

    static class HandshakeRequest
    extends TransportRequest {
        public static final HandshakeRequest INSTANCE = new HandshakeRequest();

        HandshakeRequest(StreamInput in) throws IOException {
            super(in);
        }

        private HandshakeRequest() {
        }
    }

    public static final class ContextRestoreResponseHandler<T extends TransportResponse>
    implements TransportResponseHandler<T> {
        private final TransportResponseHandler<T> delegate;
        private final Supplier<ThreadContext.StoredContext> contextSupplier;
        private volatile TimeoutHandler handler;

        public ContextRestoreResponseHandler(Supplier<ThreadContext.StoredContext> contextSupplier, TransportResponseHandler<T> delegate) {
            this.delegate = delegate;
            this.contextSupplier = contextSupplier;
        }

        @Override
        public T read(StreamInput in) throws IOException {
            return (T)((TransportResponse)this.delegate.read(in));
        }

        @Override
        public void handleResponse(T response) {
            if (this.handler != null) {
                this.handler.cancel();
            }
            try (ThreadContext.StoredContext ignore = this.contextSupplier.get();){
                this.delegate.handleResponse(response);
            }
        }

        @Override
        public void handleException(TransportException exp) {
            if (this.handler != null) {
                this.handler.cancel();
            }
            try (ThreadContext.StoredContext ignore = this.contextSupplier.get();){
                this.delegate.handleException(exp);
            }
        }

        @Override
        public String executor() {
            return this.delegate.executor();
        }

        public String toString() {
            return this.getClass().getName() + "/" + this.delegate.toString();
        }

        void setTimeoutHandler(TimeoutHandler handler) {
            this.handler = handler;
        }
    }

    final class TimeoutHandler
    implements Runnable {
        private final long requestId;
        private final long sentTime;
        private final String action;
        private final DiscoveryNode node;
        volatile Scheduler.Cancellable cancellable;

        TimeoutHandler(long requestId, DiscoveryNode node, String action) {
            this.sentTime = TransportService.this.threadPool.relativeTimeInMillis();
            this.requestId = requestId;
            this.node = node;
            this.action = action;
        }

        @Override
        public void run() {
            if (TransportService.this.responseHandlers.contains(this.requestId)) {
                long timeoutTime = TransportService.this.threadPool.relativeTimeInMillis();
                TransportService.this.timeoutInfoHandlers.put(this.requestId, new TimeoutInfoHolder(this.node, this.action, this.sentTime, timeoutTime));
                Transport.ResponseContext<? extends TransportResponse> holder = TransportService.this.responseHandlers.remove(this.requestId);
                if (holder != null) {
                    assert (holder.action().equals(this.action));
                    assert (holder.connection().getNode().equals(this.node));
                    holder.handler().handleException(new ReceiveTimeoutTransportException(holder.connection().getNode(), holder.action(), "request_id [" + this.requestId + "] timed out after [" + (timeoutTime - this.sentTime) + "ms]"));
                } else {
                    TransportService.this.timeoutInfoHandlers.remove(this.requestId);
                }
            }
        }

        public void cancel() {
            assert (!TransportService.this.responseHandlers.contains(this.requestId)) : "cancel must be called after the requestId [" + this.requestId + "] has been removed from clientHandlers";
            if (this.cancellable != null) {
                this.cancellable.cancel();
            }
        }

        public String toString() {
            return "timeout handler for [" + this.requestId + "][" + this.action + "]";
        }

        private void scheduleTimeout(TimeValue timeout) {
            this.cancellable = TransportService.this.threadPool.schedule(this, timeout, "generic");
        }
    }

    static class DirectResponseChannel
    implements TransportChannel {
        final DiscoveryNode localNode;
        private final String action;
        private final long requestId;
        final TransportService service;
        final ThreadPool threadPool;

        DirectResponseChannel(DiscoveryNode localNode, String action, long requestId, TransportService service, ThreadPool threadPool) {
            this.localNode = localNode;
            this.action = action;
            this.requestId = requestId;
            this.service = service;
            this.threadPool = threadPool;
        }

        @Override
        public String getProfileName() {
            return TransportService.DIRECT_RESPONSE_PROFILE;
        }

        @Override
        public void sendResponse(final TransportResponse response) throws IOException {
            this.service.onResponseSent(this.requestId, this.action, response);
            final TransportResponseHandler<? extends TransportResponse> handler = this.service.responseHandlers.onResponseReceived(this.requestId, this.service);
            if (handler != null) {
                String executor = handler.executor();
                if ("same".equals(executor)) {
                    this.processResponse(handler, response);
                } else {
                    this.threadPool.executor(executor).execute(new Runnable(){

                        @Override
                        public void run() {
                            this.processResponse(handler, response);
                        }

                        public String toString() {
                            return "delivery of response to [" + requestId + "][" + action + "]: " + response;
                        }
                    });
                }
            }
        }

        protected void processResponse(TransportResponseHandler handler, TransportResponse response) {
            try {
                handler.handleResponse(response);
            }
            catch (Exception e) {
                this.processException(handler, this.wrapInRemote(new ResponseHandlerFailureTransportException(e)));
            }
        }

        @Override
        public void sendResponse(final Exception exception) throws IOException {
            this.service.onResponseSent(this.requestId, this.action, exception);
            final TransportResponseHandler<? extends TransportResponse> handler = this.service.responseHandlers.onResponseReceived(this.requestId, this.service);
            if (handler != null) {
                final RemoteTransportException rtx = this.wrapInRemote(exception);
                String executor = handler.executor();
                if ("same".equals(executor)) {
                    this.processException(handler, rtx);
                } else {
                    this.threadPool.executor(handler.executor()).execute(new Runnable(){

                        @Override
                        public void run() {
                            this.processException(handler, rtx);
                        }

                        public String toString() {
                            return "delivery of failure response to [" + requestId + "][" + action + "]: " + exception;
                        }
                    });
                }
            }
        }

        protected RemoteTransportException wrapInRemote(Exception e) {
            if (e instanceof RemoteTransportException) {
                return (RemoteTransportException)e;
            }
            return new RemoteTransportException(this.localNode.getName(), this.localNode.getAddress(), this.action, e);
        }

        protected void processException(TransportResponseHandler handler, RemoteTransportException rtx) {
            try {
                handler.handleException(rtx);
            }
            catch (Exception e) {
                logger.error(() -> new ParameterizedMessage("failed to handle exception for action [{}], handler [{}]", (Object)this.action, (Object)handler), (Throwable)e);
            }
        }

        @Override
        public String getChannelType() {
            return "direct";
        }

        @Override
        public Version getVersion() {
            return this.localNode.getVersion();
        }
    }

    static class TimeoutInfoHolder {
        private final DiscoveryNode node;
        private final String action;
        private final long sentTime;
        private final long timeoutTime;

        TimeoutInfoHolder(DiscoveryNode node, String action, long sentTime, long timeoutTime) {
            this.node = node;
            this.action = action;
            this.sentTime = sentTime;
            this.timeoutTime = timeoutTime;
        }

        public DiscoveryNode node() {
            return this.node;
        }

        public String action() {
            return this.action;
        }

        public long sentTime() {
            return this.sentTime;
        }

        public long timeoutTime() {
            return this.timeoutTime;
        }
    }

    public static class HandshakeResponse
    extends TransportResponse {
        private final DiscoveryNode discoveryNode;
        private final ClusterName clusterName;
        private final Version version;

        public HandshakeResponse(DiscoveryNode discoveryNode, ClusterName clusterName, Version version) {
            this.discoveryNode = discoveryNode;
            this.version = version;
            this.clusterName = clusterName;
        }

        public HandshakeResponse(StreamInput in) throws IOException {
            super(in);
            this.discoveryNode = in.readOptionalWriteable(DiscoveryNode::new);
            this.clusterName = new ClusterName(in);
            this.version = Version.readVersion(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalWriteable(this.discoveryNode);
            this.clusterName.writeTo(out);
            Version.writeVersion(this.version, out);
        }

        public DiscoveryNode getDiscoveryNode() {
            return this.discoveryNode;
        }

        public ClusterName getClusterName() {
            return this.clusterName;
        }
    }
}

